/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.loader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;

public class JarLoader {
    private static final Application[] lookupTable = new Application[]{new Application(ApplicationID.CLI_CLIENT, "Command Line", "de.sep.sesam.cli.CliMainImpl", "sm_cli", "../../sep-cli-client/target"), new Application(ApplicationID.GUI_CLIENT, "GUI Client", "de.sep.sesam.gui.client.FrameImpl", "sm_gui", "../../sep-gui/target"), new Application(ApplicationID.GUI_SERVER, "REST Server", "de.sep.sesam.server.impl.GUIServerImpl", "sm_server", "../../sep-web/target"), new Application(ApplicationID.BRAND, "Version Info", "de.sep.sesam.common.brand.BrandImpl", "sm_brand", "../../sep-brand/target"), new Application(ApplicationID.VMACCESS, "VMWare VSphere Backup Client", "de.sep.sesam.extensions.vmware.vsphere.VMAccessImpl", "sbc_vadp", "../../sep-vadp/target"), new Application(ApplicationID.VADPACCESS, "VMWare VSphere Backup Client (NG)", "de.sep.sesam.extensions.vmware.vsphere.VadpAccessImpl", "sbc_vadp_ng", "../../sep-vadp-ng/target"), new Application(ApplicationID.EXTRACT, "Resource Extractor", "de.sep.sesam.common.extract.ExtractImpl", "sm_server", "../../sep-web/target")};

    public static void main(String[] args) {
        System.out.println("SEP JAR Loader");
        System.out.println("--------------\n");
        System.out.println("Following modules are available\n");
        for (Application application : lookupTable) {
            File jarFile = JarLoader.findJar(application.jarName, application.relativePathDev);
            if (jarFile == null) {
                System.err.println("Unable to find JAR file to load for application '" + application.name + "'. Please check your SEP sesam installation.");
                continue;
            }
            System.out.println("Application: " + application.name);
            System.out.println("\tMain Class: " + application.applicationClass);
            try {
                System.out.println("\tJAR File: " + jarFile.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("");
        }
    }

    private static void disableAccessWarnings() {
        try {
            Field field;
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            if (unsafeClass != null && (field = unsafeClass.getDeclaredField("theUnsafe")) != null) {
                field.setAccessible(true);
                Object unsafe = field.get(null);
                if (unsafe != null) {
                    Class<?> loggerClass;
                    Method putObjectVolatile = unsafeClass.getDeclaredMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
                    Method staticFieldOffset = unsafeClass.getDeclaredMethod("staticFieldOffset", Field.class);
                    if (putObjectVolatile != null && staticFieldOffset != null && (loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger")) != null) {
                        Field loggerField = loggerClass.getDeclaredField("logger");
                        Long offset = (Long)staticFieldOffset.invoke(unsafe, loggerField);
                        putObjectVolatile.invoke(unsafe, loggerClass, offset, null);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadApplication(ApplicationID id, String[] args) {
        JarLoader.disableAccessWarnings();
        Application application = null;
        for (Application candidate : lookupTable) {
            if (candidate.id != id) continue;
            application = candidate;
            break;
        }
        if (application == null) {
            System.err.println("An application with the ID '" + id + " is not known.");
            System.exit(1);
        }
        Class<?> classToLoad = null;
        try {
            classToLoad = Class.forName(application.applicationClass, true, JarLoader.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (classToLoad == null) {
            File jarFile = JarLoader.findJar(application.jarName, application.relativePathDev);
            if (jarFile == null) {
                System.err.println("Unable to find JAR file to load for application '" + application.name + "'. Please check your SEP sesam installation.");
                System.exit(1);
            }
            try {
                URLClassLoader jarClassLoader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, JarLoader.class.getClassLoader());
                classToLoad = Class.forName(application.applicationClass, true, jarClassLoader);
            }
            catch (ClassNotFoundException | MalformedURLException e) {
                e.printStackTrace();
            }
        }
        if (classToLoad != null) {
            try {
                Method method = classToLoad.getMethod("main", String[].class);
                method.invoke(null, new Object[]{args});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static File findJar(String jarName, String relativePathDev) {
        assert (jarName != null);
        String jarFullname = jarName + ".jar";
        String lookupRoot = null;
        try {
            lookupRoot = JarLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (lookupRoot != null) {
            Path lookupRootPath = new File(lookupRoot).getParentFile().toPath();
            File f = new File(lookupRootPath.toString(), jarFullname);
            if (f.canRead()) {
                return f;
            }
            f = new File(lookupRootPath.resolve("lib").toString(), jarFullname);
            if (f.canRead()) {
                return f;
            }
            if (lookupRootPath.endsWith("target") && relativePathDev != null && !"".equals(relativePathDev.trim()) && (f = new File(lookupRootPath.resolve(relativePathDev).toString(), jarFullname)).canRead()) {
                return f;
            }
        }
        return null;
    }

    private static final class Application {
        public final ApplicationID id;
        public final String name;
        public final String applicationClass;
        public final String jarName;
        public final String relativePathDev;

        public Application(ApplicationID id, String name, String applicationClass, String jarName, String relativePathDev) {
            this.id = id;
            this.name = name;
            this.applicationClass = applicationClass;
            this.jarName = jarName;
            this.relativePathDev = relativePathDev;
        }
    }

    public static enum ApplicationID {
        CLI_CLIENT,
        GUI_CLIENT,
        GUI_SERVER,
        BRAND,
        VADPACCESS,
        VMACCESS,
        EXTRACT;

    }
}

