/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.exec.core.io;

import de.sep.sesam.common.logging.ContextLogger;
import de.sep.sesam.exec.core.common.StreamOutputConsumer;
import de.sep.sesam.exec.core.io.RemoteExecStreamReader;
import de.sep.sesam.rest.exceptions.OperationNotPossibleException;
import de.sep.sesam.rest.exceptions.ServiceException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class SystemCommandExecutor {
    private List<String> commandInformation;
    private String encoding = "UTF-8";
    private RemoteExecStreamReader inputStreamReader;
    private RemoteExecStreamReader errorStreamReader;
    private InputStream inputStream;
    private InputStream errorStream;
    private boolean streamOutput = false;
    private StreamOutputConsumer consumer;
    private ContextLogger log = new ContextLogger(this.getClass());
    private final boolean debug;

    public SystemCommandExecutor(List<String> commandInformation) {
        this(commandInformation, (String)null, false, null);
    }

    public SystemCommandExecutor(List<String> commandInformation, String encoding, boolean streamOutput, boolean debug) {
        if (commandInformation == null) {
            throw new NullPointerException("The commandInformation is required.");
        }
        this.commandInformation = commandInformation;
        this.streamOutput = streamOutput;
        if (StringUtils.isNotBlank(encoding)) {
            this.encoding = encoding;
        }
        this.debug = debug;
    }

    public SystemCommandExecutor(List<String> commandInformation, String encoding, boolean debug, StreamOutputConsumer consumer) {
        if (commandInformation == null) {
            throw new NullPointerException("The commandInformation is required.");
        }
        this.commandInformation = commandInformation;
        this.streamOutput = consumer != null;
        this.consumer = consumer;
        if (StringUtils.isNotBlank(encoding)) {
            this.encoding = encoding;
        }
        this.debug = debug;
    }

    public int executeCommand() throws IOException, InterruptedException, ServiceException {
        return this.executeCommand(null);
    }

    public int executeCommand(String input) throws IOException, InterruptedException, ServiceException {
        return this.executeCommand(input, 0L);
    }

    public int executeCommand(String input, long timeout) throws IOException, InterruptedException, ServiceException {
        String method = "executeCommand";
        int exitValue = -99;
        try {
            boolean destroy;
            Process process;
            block17: {
                ProcessBuilder pb = new ProcessBuilder(this.commandInformation);
                process = pb.start();
                try (PrintWriter pwStdOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(process.getOutputStream(), this.encoding)));){
                    this.inputStream = process.getInputStream();
                    this.errorStream = process.getErrorStream();
                    if (input == null) break block17;
                    try {
                        String input_utf8 = new String(input.getBytes(), this.encoding);
                        this.log.info("executeCommand", "stdout (" + this.encoding + "): [" + input_utf8 + "]", new Object[0]);
                    }
                    catch (UnsupportedEncodingException e) {
                        this.log.info("executeCommand", "Failed to encode (" + this.encoding + "): [" + input + "]", new Object[0]);
                        e.printStackTrace();
                        throw e;
                    }
                    pwStdOut.println(input);
                }
            }
            this.inputStreamReader = new RemoteExecStreamReader("stdout", this.inputStream, this.streamOutput, this.encoding, this.debug);
            this.inputStreamReader.setConsumer(this.consumer);
            this.errorStreamReader = new RemoteExecStreamReader("stderr", this.errorStream, this.streamOutput, this.encoding, this.debug);
            this.errorStreamReader.setConsumer(this.consumer);
            this.inputStreamReader.start();
            this.errorStreamReader.start();
            boolean bl = destroy = timeout <= 0L;
            if (timeout <= 0L) {
                exitValue = process.waitFor();
            } else {
                boolean exited = process.waitFor(timeout, TimeUnit.SECONDS);
                if (exited) {
                    destroy = true;
                    exitValue = process.exitValue();
                }
            }
            this.inputStreamReader.interrupt();
            this.errorStreamReader.interrupt();
            this.inputStreamReader.join();
            this.errorStreamReader.join();
            if (destroy) {
                process.destroy();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            if (e.getMessage().contains("error=2")) {
                StringBuilder sb = new StringBuilder();
                sb.append(e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
                sb.append("  (#> ");
                sb.append(this.commandInformation.toString().replaceAll("[\\[\\],]", ""));
                sb.append(")");
                throw new OperationNotPossibleException(OperationNotPossibleException.ONPMessage.EXTERNAL_PROCESS_FAILED, sb.toString());
            }
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return exitValue;
    }

    public String getStandardOutputFromCommand() {
        return this.inputStreamReader == null ? "" : this.inputStreamReader.getOutput();
    }

    public byte[] getStandardOutputAsByte() {
        return this.inputStreamReader == null ? new byte[]{} : this.inputStreamReader.getRawOutput();
    }

    public String getStandardErrorFromCommand() {
        return this.errorStreamReader == null ? "" : this.errorStreamReader.getOutput();
    }
}

