/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.exec.core.io;

import de.sep.sesam.common.logging.ContextLogger;
import de.sep.sesam.common.logging.SepLogLevel;
import de.sep.sesam.exec.core.common.StreamOutputConsumer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;

public class RemoteExecStreamReader
extends Thread {
    private final ContextLogger log = new ContextLogger(RemoteExecStreamReader.class);
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private final String type;
    private InputStream stream;
    private final boolean streamOnRead;
    private final String encoding;
    private StreamOutputConsumer consumer;
    private final boolean debug;

    public RemoteExecStreamReader(String type, InputStream stream, boolean streamOnRead, String encoding, boolean debug) {
        assert (type != null);
        assert (stream != null);
        assert (encoding != null);
        this.type = type;
        this.stream = stream;
        this.streamOnRead = streamOnRead;
        this.encoding = encoding;
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String output;
        String method = "run";
        ByteArrayOutputStream outputLineBuffer = new ByteArrayOutputStream();
        if (this.debug) {
            this.consumer = line -> this.log.info("readLine", "[" + this.type + "] Line read: " + line, new Object[0]);
        }
        int countTries = 0;
        while (true) {
            try {
                StringBuilder sb;
                int c;
                while ((c = this.stream.read()) >= 0) {
                    this.bos.write(c);
                    if (!this.streamOnRead && !this.debug) continue;
                    if (c == 10) {
                        sb = new StringBuilder();
                        try {
                            sb.append(new String(outputLineBuffer.toByteArray(), this.encoding));
                        }
                        catch (UnsupportedEncodingException e) {
                            sb.append(new String(outputLineBuffer.toByteArray()));
                        }
                        outputLineBuffer.reset();
                        sb.append("\n");
                        String line2 = sb.toString();
                        if (this.consumer == null) continue;
                        this.consumer.consume(line2);
                        continue;
                    }
                    outputLineBuffer.write(c);
                }
                if (outputLineBuffer.size() <= 0) continue;
                sb = new StringBuilder();
                try {
                    sb.append(new String(outputLineBuffer.toByteArray(), this.encoding));
                }
                catch (UnsupportedEncodingException e) {
                    sb.append(new String(outputLineBuffer.toByteArray()));
                }
                if (this.consumer == null) continue;
                this.consumer.consume(sb.toString());
                continue;
            }
            catch (InterruptedIOException e) {
                this.log.info(method, e.getMessage(), new Object[0]);
                try {
                    Thread.sleep(10L);
                    if (++countTries == 5) break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            catch (IOException ioe) {
            }
            catch (Throwable t) {
            }
            finally {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            break;
        }
        String string = output = "stderr".equals(this.type) || this.log.isEnabled(SepLogLevel.TRACE) ? this.getOutput().toString() : null;
        if (StringUtils.isNotBlank(output)) {
            if ("stderr".equals(this.type)) {
                this.log.info("run (" + this.type + ")", "\n" + output, new Object[0]);
            } else {
                this.log.trace("run (" + this.type + ")", "\n" + output, new Object[0]);
            }
        }
    }

    public String getOutput() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(new String(this.bos.toByteArray(), this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            sb.append(new String(this.bos.toByteArray()));
        }
        return sb.toString();
    }

    public byte[] getRawOutput() {
        return this.bos.toByteArray();
    }

    public void setConsumer(StreamOutputConsumer consumer) {
        this.consumer = consumer;
    }
}

