/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.exec.core.impl;

import de.sep.sesam.common.logging.ContextLogger;
import de.sep.sesam.exec.core.ExeInfo;
import de.sep.sesam.exec.core.common.StreamOutputConsumer;
import de.sep.sesam.exec.core.io.SystemCommandExecutor;
import de.sep.sesam.rest.exceptions.ServiceException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class RemoteExec {
    private final ContextLogger log = new ContextLogger(this.getClass());
    private boolean doExec = true;

    public RemoteExec(boolean exec) {
        this.doExec = exec;
    }

    public ExeInfo executeProcess(List<String> cmd, String encoding) throws ServiceException {
        return this.executeProcess(cmd, encoding, null, false, false);
    }

    public ExeInfo executeProcess(List<String> cmd, String encoding, String input, boolean streamOutput, boolean debug) throws ServiceException {
        assert (cmd != null);
        String method = "executeProcess";
        ExeInfo data = new ExeInfo();
        data.setCommandFromList(cmd);
        data.setInput(input);
        if (!this.doExec) {
            return data;
        }
        if (!CollectionUtils.containsAny(cmd, "gv_daylbl")) {
            this.log.info("executeProcess", String.format("executeProcess: command [%s], encoding [%s]", data.getQuotedCommand(), encoding), new Object[0]);
        }
        SystemCommandExecutor commandExecutor = new SystemCommandExecutor(cmd, encoding, streamOutput, debug);
        int result = -99;
        try {
            result = commandExecutor.executeCommand(input);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String stdout = commandExecutor.getStandardOutputFromCommand();
        String stderr = commandExecutor.getStandardErrorFromCommand();
        data.setExitCode(result);
        data.setErrorMessage(stderr);
        if (stdout != null) {
            data.setRetVal(stdout);
        }
        return data;
    }

    public ExeInfo executeProcess(List<String> cmd, String encoding, String input, boolean debug, StreamOutputConsumer consumer) throws ServiceException {
        String method = "executeProcess";
        ExeInfo data = new ExeInfo();
        data.setCommandFromList(cmd);
        data.setInput(input);
        if (!this.doExec) {
            return data;
        }
        this.log.info("executeProcess", String.format("executeProcess: command [%s], encoding [%s]", data.getQuotedCommand(), encoding), new Object[0]);
        SystemCommandExecutor commandExecutor = new SystemCommandExecutor(cmd, encoding, debug, consumer);
        int result = -99;
        try {
            result = commandExecutor.executeCommand(input);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        String stdout = commandExecutor.getStandardOutputFromCommand();
        String stderr = commandExecutor.getStandardErrorFromCommand();
        data.setExitCode(result);
        data.setErrorMessage(stderr);
        if (stdout != null) {
            data.setRetVal(stdout);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExeInfo executeWriteProcess(List<String> cmd, String fileContent) {
        String method = "executeWriteProcess";
        ExeInfo data = new ExeInfo();
        data.setCommandFromList(cmd);
        if (!this.doExec) {
            return data;
        }
        this.log.info("executeWriteProcess", String.format("Process started [command=%s]", data.getQuotedCommand()), new Object[0]);
        int retsbcValue = 2;
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(false);
        Process p = null;
        try {
            p = pb.start();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return data;
        }
        InputStream is = p.getInputStream();
        InputStream errIs = p.getErrorStream();
        OutputStream os = p.getOutputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        BufferedReader errBr = new BufferedReader(new InputStreamReader(errIs, StandardCharsets.UTF_8));
        StringReader buf = new StringReader(fileContent);
        BufferedReader in = new BufferedReader(buf);
        ErrorStreamThread errorStreamThread = new ErrorStreamThread(errBr);
        errorStreamThread.start();
        int b = 0;
        try {
            while ((b = in.read()) != -1) {
                os.write(b);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            buf.close();
            try {
                os.flush();
                os.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        try {
            retsbcValue = p.waitFor();
        }
        catch (InterruptedException e) {
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        data.setExitCode(retsbcValue);
        data.setErrorMessage(errorStreamThread.getErrorMessage());
        this.log.info("executeWriteProcess", String.format("Process finished: [command=%s, exitcode=%s]", data.getQuotedCommand(), data.getExitCode()), new Object[0]);
        return data;
    }

    private class ErrorStreamThread
    extends Thread {
        private String line;
        private final StringBuilder sbErrorLog = new StringBuilder();
        private BufferedReader errBr = null;

        public ErrorStreamThread(BufferedReader errBr) {
            this.errBr = errBr;
        }

        @Override
        public void run() {
            try {
                while ((this.line = this.errBr.readLine()) != null) {
                    this.sbErrorLog.append(this.line + "\n");
                    System.err.println(this.line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getErrorMessage() {
            return this.errBr.toString();
        }
    }
}

