/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.exec.core.impl;

import de.sep.sesam.common.logging.ContextLogger;
import de.sep.sesam.exec.core.ExeInfo;
import de.sep.sesam.exec.core.common.ExeFormatter;
import de.sep.sesam.exec.core.common.ExeProcess;
import de.sep.sesam.exec.core.common.StreamOutputConsumer;
import de.sep.sesam.exec.core.impl.RemoteExec;
import de.sep.sesam.model.core.dto.ClientUpdateDto;
import de.sep.sesam.model.core.types.DSDriveMode;
import de.sep.sesam.model.core.types.SMLoaderAction;
import de.sep.sesam.rest.exceptions.ServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class RemoteAccessNew {
    private final ContextLogger log = new ContextLogger(this.getClass());
    private ExeInfo lastCommand;
    protected boolean doExec = true;

    public RemoteAccessNew(boolean doExec) {
        this.doExec = doExec;
    }

    public ExeInfo executeSMArch(boolean sync, String action, String driveNum, String pool, String introduceMode, String externalIdentifier, String introduceOption, String label, String mediaType, String c, String barcode, String mpLocation, String saveset, String verbose, String options) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMArch";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_arch");
        formatter.setSMArchCommand(action, driveNum, pool, introduceMode, externalIdentifier, introduceOption, label, mediaType, c, barcode, mpLocation, saveset, verbose, options);
        this.log.info("executeSMArch", String.format("Starting executeSMArch: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMBreak(boolean sync, String caller, String remoteTapeServer, String sesamServer, Long driveNum, String driveGrp, String commandSavesetId, String backupSavesetId, boolean isBackupGroup, String restoreId, String migrationId, String pid, String tracingFile, String verbose) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMBreak";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_break");
        formatter.setSMBreak(caller, remoteTapeServer, sesamServer, driveNum, driveGrp, commandSavesetId, backupSavesetId, isBackupGroup, restoreId, migrationId, pid, tracingFile, verbose);
        this.log.info("executeSMBreak", String.format("Starting executeSMBreak: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMUpdateClient(String timestamp, ClientUpdateDto dto) throws ServiceException {
        ExeInfo exeInfo;
        assert (dto != null);
        boolean sync = Boolean.TRUE.equals(dto.getSync());
        String method = "executeSMUpdateClient";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_update_client");
        formatter.setSMUpdateClient(timestamp, dto);
        this.log.info("executeSMUpdateClient", String.format("Starting executeSMUpdateClient: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMConfigDrives(boolean sync, Long driveNum, DSDriveMode dsDriveMode) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMConfigDrives";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_config_drives");
        formatter.setSMConfigDrives(driveNum, dsDriveMode);
        this.log.info("executeSMConfigDrives", String.format("Starting executeSMConfigDrives: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMConfigLoaders(boolean sync, Long actLoader) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMConfigLoaders";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_config_loaders");
        formatter.setSMConfigLoaders(actLoader);
        this.log.info("executeSMConfigLoaders", String.format("Starting executeSMConfigLoaders: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMDailySchedule(boolean sync, String scheduleName, String date) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMDailySchedule";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_daily_schedule");
        formatter.setSMDailySchedule(scheduleName, date);
        this.log.info("executeSMDailySchedule", String.format("Starting executeSMDailySchedule: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMDatastore(boolean sync, String action, String ssid, String driveNum, String dataStore, String mediumLabel, String noAction, String force, boolean genMode, String backupType, String callerId, String restoreId, String options) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMDatastore";
        ExeFormatter formatter = null;
        formatter = StringUtils.equals("purge", action) ? new ExeFormatter(sync, "sm_remove_saveset") : new ExeFormatter(sync, "sm_data_store");
        assert (formatter != null);
        formatter.setSMDatastore(action, ssid, driveNum, dataStore, mediumLabel, noAction, force, genMode, backupType, callerId, restoreId, null, null, options);
        this.log.info("executeSMDatastore", String.format("Starting executeSMDatastore: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMDatastore(String action, String ssid, String driveNum, String dataStore, String mediumLabel, String noAction, String force, boolean genMode, String backupType, StreamOutputConsumer consumer, String callerId, String restoreId, String client, String mountPath, String options) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMDatastore";
        ExeFormatter formatter = null;
        formatter = StringUtils.equals("purge", action) ? new ExeFormatter(true, "sm_remove_saveset") : new ExeFormatter(true, "sm_data_store");
        assert (formatter != null);
        formatter.setSMDatastore(action, ssid, driveNum, dataStore, mediumLabel, noAction, force, genMode, backupType, callerId, restoreId, client, mountPath, options);
        this.log.info("executeSMDatastore", String.format("Starting executeSMRemoveSaveset: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null, null, false, consumer);
        return exeInfo;
    }

    public ExeInfo executeSMDedupInterface(String deviceServer, String ... params) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMDedupInterface";
        ArrayList<String> command = new ArrayList<String>(Collections.singleton("sm_dedup_interface"));
        if (StringUtils.isNotBlank(deviceServer) && !StringUtils.equalsIgnoreCase(deviceServer, "LOCAL")) {
            command.add(0, deviceServer);
            command.add(0, "sm_rexec");
        }
        if (ArrayUtils.isNotEmpty(params)) {
            command.addAll(Arrays.asList(params));
        }
        this.log.info("executeSMDedupInterface", String.format("Starting executeSMDedupInterface: %s", command), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(command, null);
        return exeInfo;
    }

    public ExeInfo executeSMDrive(boolean sync, String keyword, Long driveNum, String option) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMDrive";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_drive");
        formatter.setSMDrive(keyword, driveNum, option);
        this.log.info("executeSMDrive", String.format("Starting executeSMDrive: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMDriveSts(boolean sync, String P1, String P2, String P3) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMDriveSts";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_drive_sts");
        formatter.setSMDriveSts(P1, P2, P3);
        this.log.info("executeSMDriveSts", String.format("Starting executeSMDriveSts: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMInfo(boolean sync, String P1, String P2, String P3) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMInfo";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_info");
        formatter.setSMInfo(P1, P2, P3);
        this.log.info("executeSMInfo", String.format("Starting executeSMInfo: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMInventory(boolean sync, Long loaderNumber, String mediaPool, Long driveNumber, String action, String volumeType, String slotArea, Boolean labelFlag, Boolean fastMode, String driveGroup, String storagePoolLocation, String verbose, Boolean adjustWithBarcode) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMInventory";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_inventory");
        formatter.setSMInventory(loaderNumber, mediaPool, driveNumber, action, volumeType, slotArea, labelFlag, fastMode, driveGroup, storagePoolLocation, verbose, adjustWithBarcode);
        this.log.info("executeSMInventory", String.format("Starting executeSMInventory: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMLisItems(boolean sync, Boolean searchFlag, String genFlag, String mailFlag, String savesetID, String searchOption, String searchPattern, String dir) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMLisItems";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_lis_items");
        formatter.setSMLisItems(searchFlag, genFlag, mailFlag, savesetID, searchOption, searchPattern, dir);
        this.log.info("executeSMLisItems", String.format("Starting executeSMLisItems: %s", formatter.getCommandForLog()), new Object[0]);
        formatter.setSMLisItems(searchFlag, genFlag, mailFlag, savesetID, searchOption, searchPattern, "-");
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null, StringUtils.isNotBlank(dir) ? dir : searchOption, false, false);
        return exeInfo;
    }

    public ExeInfo executeSMLoader(boolean sync, SMLoaderAction action, Long loaderNumber, String driveNumber, String port, String slotNumberOrLabel, String option, String storeLocation, String logFile, String verbose) throws ServiceException {
        String method = "executeSMLoader";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_loader");
        formatter.setSMLoader(action, loaderNumber, driveNumber, port, slotNumberOrLabel, option, storeLocation, logFile, verbose);
        this.log.info("executeSMLoader", String.format("Starting executeSMLoader: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        ExeInfo exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMProcessSts(boolean sync, String P1, String P2) throws ServiceException {
        ExeInfo exeInfo;
        ExeFormatter formatter = new ExeFormatter(sync, "sm_process_sts");
        String method = "executeSMProcessSts";
        this.log.info("executeSMProcessSts", String.format("Starting executeSMProcessSts: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMRExec(boolean sync, String outFile, String errFile, String verbose, String hostName, String P1, String P2, String P3) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMRExec";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_rexec");
        formatter.setSMRExec(outFile, errFile, verbose, hostName, P1, P2, P3);
        this.log.info("executeSMRExec", String.format("Starting executeSMRExec: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMRecover(boolean sync, String action, String driveNum, String file, String outputFile, String task, String sepuler, String password, String targetPath, String verboseLevelSBC, String verboseLevelSMRecover, Boolean unattendedMode) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMRecover";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_recover");
        formatter.setSMRecover(action, driveNum, file, outputFile, task, sepuler, password, targetPath, verboseLevelSBC, verboseLevelSMRecover, unattendedMode);
        this.log.info("executeSMRecover", String.format("Starting executeSMRecover: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMSearchLis(boolean sync, String searchPattern, ExeProcess.SEARCH_TYPE searchType, String client, Date from, Date to, String task) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMSearchLis";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_search_lis");
        formatter.setSMSearchLis(searchPattern, searchType, client, from, to, task);
        this.log.info("executeSMSearchLis", String.format("Starting executeSMSearchLis: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMSetup(boolean sync, String function, String options, String username, String client, String rights, String language, String verbose) throws ServiceException {
        return this.executeSMSetup(sync, function, options, username, client, rights, language, verbose, false, false);
    }

    public ExeInfo executeSMSetup(boolean sync, String function, String options, String username, String client, String rights, String language, String verbose, boolean ldapEnabled, boolean adEnabled) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMSetup";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_setup");
        formatter.setSMSetup(function, options, username, client, rights, language, verbose, ldapEnabled, adEnabled);
        this.log.info("executeSMSetup", String.format("Starting executeSMSetup: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMSho(boolean sync, String p1, String task, String saveset, String taskType, String taskTypeOption, String option, String p2, String p3, String p4, String p5, Long credentialsId, String additionalOptions) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMSho";
        String input = null;
        ExeFormatter formatter = new ExeFormatter(sync, "sm_sho");
        formatter.setSMSho(p1, task, saveset, taskType, taskTypeOption, option, p2, p3, p4, p5, credentialsId, additionalOptions);
        if (p1.equals("dir")) {
            input = p3;
            p3 = "-";
        }
        this.log.info("executeSMSho", String.format("Starting executeSMSho: %s", formatter.getCommandForLog()), new Object[0]);
        formatter.setSMSho(p1, task, saveset, taskType, taskTypeOption, option, p2, p3, p4, p5, credentialsId, additionalOptions);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null, input, false, false);
        return exeInfo;
    }

    public ExeInfo executeSMShoWrite(String fileName, String clientId, String fileContent) {
        ExeInfo exeInfo;
        String method = "executeSMShoWrite";
        ExeFormatter formatter = new ExeFormatter(true, "sm_sho");
        formatter.addElement("", "write");
        formatter.addElement("", fileName);
        formatter.addElement("", clientId);
        this.log.info("executeSMShoWrite", String.format("Starting executeSMShoWrite: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeWriteProcess(formatter.getCommandList(false), fileContent);
        return exeInfo;
    }

    public ExeInfo executeSmDbExport(String fileName) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSmDbExport";
        ExeFormatter formatter = new ExeFormatter(true, "sm_db");
        formatter.addElement("", "export");
        formatter.addElement("-f", fileName);
        this.log.info("executeSmDbExport", String.format("Starting executeSmDbExport: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo startSMDBUpdate(String fileName, boolean disasterflag) throws ServiceException {
        ExeInfo exeInfo;
        String method = "startSMDBUpdate";
        ExeFormatter formatter = new ExeFormatter(true, "sm_db_update");
        formatter.addElement("", "update");
        if (StringUtils.isNotBlank(fileName)) {
            formatter.addElement("-i", fileName);
        }
        if (disasterflag) {
            formatter.addElement("-d", "y");
        }
        this.log.info("startSMDBUpdate", String.format("Starting startSMDBUpdate: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSMMount(String action, String client, String backupType, String mountPath, String saveset, String nfsInterface, String vCenter, Collection<String> drives, String restoreId, String esxServer, String mount, boolean genMode, String options, StreamOutputConsumer consumer) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMMount";
        ExeFormatter formatter = new ExeFormatter(true, "sm_mount");
        formatter.setSMPrepareVMDK(action, client, backupType, mountPath, saveset, nfsInterface, vCenter, drives, restoreId, esxServer, mount, genMode, options);
        this.log.info("executeSMMount", String.format("Starting executeSMMount: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null, null, false, consumer);
        return exeInfo;
    }

    public ExeInfo executeSMCopyFiles(String action, String restoreTask, String proxy, String client, String restoreTarget, String mode, String restoreId, String saveset, String iFace, String mountDir, String logOutputToFile, StreamOutputConsumer consumer) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeSMCopyFiles";
        ExeFormatter formatter = new ExeFormatter(true, "sm_copy_files");
        formatter.setSMCopyVM(action, restoreTask, proxy, client, restoreTarget, mode, restoreId, saveset, iFace, mountDir);
        this.log.info("executeSMCopyFiles", String.format("Starting smCopyFiles: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null, null, false, consumer);
        return exeInfo;
    }

    public ExeInfo executeRemoteBrowseDir(boolean sync, String hostName, String path, boolean verbose) throws ServiceException {
        ExeInfo exeInfo;
        ExeFormatter formatter = new ExeFormatter(sync, "sm_rexec");
        String method = "executeRemoteBrowseDir";
        formatter.setRemoteBrowseDir(hostName, path, verbose);
        this.log.info("executeRemoteBrowseDir", String.format("Starting executeSMRExec: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeRemoteSMClient(boolean sync, String hostName, String ... args) throws ServiceException {
        ExeInfo exeInfo;
        ExeFormatter formatter = new ExeFormatter(sync, "sm_rexec");
        String method = "executeRemoteSMClient";
        formatter.setRemoteSMClient(hostName, args);
        this.log.info("executeRemoteSMClient", String.format("Starting executeSMRExec: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeSmSesam(boolean sync, String function, List<String> savesets, String preferredMediaPool, String eol, Long drive, String user, String label, String locationName, String clientName, String taskname, boolean singleSaveset, String backupId, boolean purge) throws ServiceException {
        String method = "executeSmSesam";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_sesam");
        int MAX_COMMAND_LENGTH = 8191;
        ExeInfo exeInfo = null;
        boolean adjustEol = StringUtils.equals(function, "adjust_eol");
        if (adjustEol) {
            formatter.setSMSesam(function, null, preferredMediaPool, eol, drive, user, label, singleSaveset, null, null, null, null, false);
        } else {
            formatter.setSMSesam(function, savesets, preferredMediaPool, eol, drive, user, label, singleSaveset, locationName, clientName, taskname, backupId, purge);
        }
        int length = formatter.getCommand().length();
        if (CollectionUtils.isEmpty(savesets) || savesets.get(0) == null || !adjustEol) {
            this.log.info("executeSmSesam", String.format("Starting executeSmSesam: %s", formatter.getCommandForLog()), new Object[0]);
            RemoteExec remoteExec = new RemoteExec(this.doExec);
            exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        } else {
            for (int i = 0; i < savesets.size(); ++i) {
                String saveset = savesets.get(i);
                if (length + saveset.length() + 1 > 8191) {
                    this.log.info("executeSmSesam", String.format("Max allowed command length reached, Starting executeSmSesam: %s", formatter.getCommandForLog()), new Object[0]);
                    remoteExec = new RemoteExec(this.doExec);
                    exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
                    formatter = new ExeFormatter(sync, "sm_sesam");
                    formatter.setSMSesam(function, null, preferredMediaPool, eol, drive, user, label, singleSaveset, null, null, null, null, false);
                } else if (i == savesets.size() - 1) {
                    formatter.addElement("", saveset);
                    this.log.info("executeSmSesam", String.format("Starting executeSmSesam: %s", formatter.getCommandForLog()), new Object[0]);
                    remoteExec = new RemoteExec(this.doExec);
                    exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
                }
                formatter.addElement("", saveset);
                length = formatter.getCommand().length();
            }
        }
        this.lastCommand = exeInfo;
        return exeInfo;
    }

    public String getUniqueId() throws ServiceException {
        String method = "getUniqueId";
        int MAX_TRIES = 3;
        String result = null;
        for (int i = 0; i < 3; ++i) {
            if (result == null || result.length() == 0) {
                this.log.info("getUniqueId", "Try to create unique ID [" + (i + 1) + "]", new Object[0]);
                result = this.executeSMInfo(true, "get_unique_id", null, null).getRetVal();
                if (!StringUtils.isBlank(result)) continue;
                this.log.info("getUniqueId", "Create unique ID failed", new Object[0]);
                continue;
            }
            if ((result = result.trim()).contains("\n")) {
                result = result.substring(result.lastIndexOf("\n") + 1);
            }
            this.log.info("getUniqueId", "Create unique ID completed successfully -> " + result, new Object[0]);
            break;
        }
        if (result == null || result.length() == 0) {
            this.log.info("getUniqueId", "Create unique id failed", new Object[0]);
        }
        return result;
    }

    public ExeInfo executeSMGlbv(boolean sync, String command, String name, String value) throws ServiceException {
        RemoteExec remoteExec;
        ExeInfo exeInfo;
        assert (name != null);
        assert (command != null);
        if (!StringUtils.equalsAny(command, "r", "R", "w", "d")) {
            throw new IllegalArgumentException("command must be either \"r\", \"R\", \"w\" or \"d\" (case sensitive)");
        }
        if (StringUtils.equals(command, "w") && value == null) {
            throw new IllegalArgumentException("If command is \"w\" value must not be empty.");
        }
        String method = "executeSMGlbv";
        ExeFormatter formatter = new ExeFormatter(sync, "sm_glbv");
        formatter.setSMGlbv(command, name, value);
        if (!StringUtils.equals(name, "gv_daylbl")) {
            this.log.info("executeSMGlbv", String.format("Starting executeSMGlbv: %s", formatter.getCommandForLog()), new Object[0]);
        }
        if (StringUtils.endsWith((exeInfo = (remoteExec = new RemoteExec(this.doExec)).executeProcess(formatter.getCommandList(false), null)).getRetVal(), "\r\n")) {
            String filteredFileName = StringUtils.substring(exeInfo.getRetVal(), 0, exeInfo.getRetVal().indexOf("\r"));
            exeInfo.setRetVal(filteredFileName);
        } else if (StringUtils.endsWith(exeInfo.getRetVal(), "\n")) {
            String filteredFileName = StringUtils.substring(exeInfo.getRetVal(), 0, exeInfo.getRetVal().indexOf("\n"));
            exeInfo.setRetVal(filteredFileName);
        }
        this.lastCommand = exeInfo;
        return exeInfo;
    }

    public String importSi3Seed(String driveNum, String fileName) throws ServiceException {
        ExeInfo exeInfo = this.executeSmReplicate("seed", driveNum, fileName);
        return exeInfo.getRetVal();
    }

    public ExeInfo executeSmReplicate(String action, String driveNum, String fileName) throws ServiceException {
        ExeInfo exeInfo;
        String method = "sm_replicate";
        ExeFormatter formatter = new ExeFormatter(true, "sm_replicate");
        formatter.addElement("-A", action);
        formatter.addElement("-D", driveNum);
        formatter.addElement("-f", fileName);
        this.log.info("sm_replicate", String.format("Starting executeSmReplicate: %s", formatter.getCommandForLog()), new Object[0]);
        RemoteExec remoteExec = new RemoteExec(this.doExec);
        this.lastCommand = exeInfo = remoteExec.executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo executeHtml2Pdf(String converterPath, String inputFile, String outputFile, String orientation, String paperSize, String zoom) throws ServiceException {
        ExeInfo exeInfo;
        String method = "executeHtml2Pdf";
        assert (StringUtils.isNotBlank(converterPath));
        assert (StringUtils.isNotBlank(inputFile));
        assert (StringUtils.isNotBlank(outputFile));
        ExeFormatter formatter = new ExeFormatter(true, converterPath);
        formatter.setHtml2Pdf(inputFile, outputFile, orientation, paperSize, zoom);
        this.log.info("executeHtml2Pdf", "Starting {0}: {1}", converterPath, formatter.getCommandForLog());
        this.lastCommand = exeInfo = new RemoteExec(this.doExec).executeProcess(formatter.getCommandList(false), null);
        return exeInfo;
    }

    public ExeInfo getLastCommand() {
        return this.lastCommand;
    }

    public void resetLastCommand() {
        this.lastCommand = null;
    }
}

