/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.exec.core.common;

import de.sep.sesam.common.date.DateUtils;
import de.sep.sesam.common.text.TextUtils;
import de.sep.sesam.common.util.Joiner;
import de.sep.sesam.common.util.UTF8Utils;
import de.sep.sesam.exec.core.common.ExeProcess;
import de.sep.sesam.model.core.dto.ClientUpdateDto;
import de.sep.sesam.model.core.types.DSDriveMode;
import de.sep.sesam.model.core.types.SMLoaderAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ExeFormatter {
    private final List<Object[]> _vParameter = new ArrayList<Object[]>();
    private final String QUOTE_MARK = "\"";
    private final boolean sync;
    private final String filename;

    public ExeFormatter(boolean sync, String filename) {
        this.sync = sync;
        this.filename = filename;
        this.init();
    }

    private void init() {
        if (!this.sync) {
            this.addElement(null, "sm_gui_request");
        }
        assert (StringUtils.isNotBlank(this.filename));
        this.addElement(null, this.filename);
    }

    public String getCommandForLog() {
        return Joiner.on(' ').join(this.getCommandList(true));
    }

    public List<String> getCommandList(boolean withQuotes) {
        Iterator<Object[]> it = this._vParameter.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            Object argument;
            Object[] elem = it.next();
            Object parameter = StringUtils.trim((String)elem[0]);
            if (elem[1] != null && elem[1] instanceof Boolean) {
                boolean setOnlyParameter = (Boolean)elem[1];
                if (!setOnlyParameter || !StringUtils.isNotBlank((CharSequence)parameter)) continue;
                if (!((String)parameter).startsWith("-")) {
                    parameter = "-" + (String)parameter;
                }
                if (withQuotes) {
                    parameter = "\"" + (String)parameter + "\"";
                }
                list.add((String)parameter);
                continue;
            }
            if (!(elem[1] instanceof String) || StringUtils.isBlank((CharSequence)(argument = StringUtils.trim((String)elem[1])))) continue;
            if (StringUtils.isNotBlank((CharSequence)parameter)) {
                if (!((String)parameter).startsWith("-")) {
                    parameter = "-" + (String)parameter;
                }
                if (withQuotes) {
                    parameter = "\"" + (String)parameter + "\"";
                }
                list.add((String)parameter);
            }
            if (!(argument instanceof String) || ((String)parameter).equals(argument)) continue;
            if (withQuotes) {
                argument = "\"" + (String)argument + "\"";
            }
            list.add((String)argument);
        }
        return list;
    }

    public void addElement(String option, Object argument) {
        if (option == null) {
            option = "";
        }
        if (argument == null) {
            argument = "";
        }
        if (argument instanceof Number) {
            argument = argument.toString();
        }
        if (!(argument instanceof String) && !(argument instanceof Boolean)) {
            return;
        }
        if (StringUtils.isBlank(option) && StringUtils.isBlank((String)argument)) {
            return;
        }
        this._vParameter.add(new Object[]{option, argument});
    }

    public void addAllElements(List<String> arguments) {
        if (CollectionUtils.isEmpty(arguments)) {
            return;
        }
        arguments.forEach(a -> this.addElement(null, a));
    }

    private void clear() {
        if (this._vParameter.isEmpty()) {
            return;
        }
        this._vParameter.clear();
        this.init();
    }

    public String getCommand() {
        StringBuilder sb = new StringBuilder();
        List<String> list = this.getCommandList(false);
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            String elem = it.next();
            if (elem.contains(" ") && !elem.matches("\".*\"")) {
                sb.append("\"").append(elem).append("\"");
            } else {
                sb.append(elem);
            }
            if (!it.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public void setSMArchCommand(String action, String driveNum, String pool, String introduceMode, String externalIdentifier, String introduceOption, String label, String mediaType, String c, String barcode, String mpLocation, String saveset, String verbose, String options) {
        this.clear();
        this.addElement("", action);
        this.addElement("d", driveNum);
        this.addElement("m", pool);
        this.addElement("i", introduceMode);
        this.addElement("I", externalIdentifier);
        this.addElement("o", introduceOption);
        this.addElement("t", label);
        this.addElement("T", mediaType);
        this.addElement("c", c);
        this.addElement("b", barcode);
        this.addElement("L", mpLocation);
        this.addElement("s", saveset);
        this.addElement("v", verbose);
        this.addElement("O", options);
    }

    public void setSMBreak(String caller, String remoteTapeServer, String sesamServer, Long driveNum, String driveGrp, String commandSavesetId, String backupSavesetId, boolean isBackupGroup, String restoreId, String migrationId, String pid, String tracingFile, String verbose) {
        this.clear();
        this.addElement("u", caller);
        this.addElement("S", remoteTapeServer);
        this.addElement("C", sesamServer);
        this.addElement("d", driveNum);
        this.addElement("g", driveGrp);
        this.addElement("x", commandSavesetId);
        this.addElement(isBackupGroup ? "G" : "b", backupSavesetId);
        this.addElement("r", restoreId);
        this.addElement("c", migrationId);
        this.addElement("p", pid);
        this.addElement("t", tracingFile);
        this.addElement("v", verbose);
    }

    public void setSMUpdateClient(String timestamp, ClientUpdateDto dto) {
        assert (dto != null);
        boolean queue = false;
        boolean actionSet = false;
        this.clear();
        if (Boolean.TRUE.equals(dto.getInstall())) {
            this.addElement(null, "in");
            queue = true;
            actionSet = true;
        }
        if (!actionSet && Boolean.TRUE.equals(dto.getUninstall())) {
            this.addElement(null, "un");
            queue = true;
            actionSet = true;
        }
        if (!actionSet && Boolean.TRUE.equals(dto.getUpdate())) {
            this.addElement(null, "up");
            queue = true;
            actionSet = true;
        }
        if (Boolean.TRUE.equals(dto.getServicepacks())) {
            if (!actionSet) {
                this.addElement(null, "su");
            } else {
                this.addElement("s", "1");
            }
            queue = true;
            actionSet = true;
        }
        if (!actionSet && Boolean.TRUE.equals(dto.getUiserver())) {
            this.addElement(null, "gu");
            dto.setClientName(null);
            actionSet = true;
        }
        if (!actionSet && Boolean.TRUE.equals(dto.getUpdateCheck())) {
            this.addElement(null, "cu");
            actionSet = true;
            queue = true;
        }
        if (Boolean.TRUE.equals(dto.getRemoteAccessCheck()) || Boolean.TRUE.equals(dto.getSbcConnectionCheck())) {
            if (!actionSet) {
                this.addElement(null, "cc");
                actionSet = true;
                queue = true;
            }
            this.addElement("C", Boolean.TRUE.equals(dto.getRemoteAccessCheck()) ? "r" : "s");
        }
        if (!actionSet && Boolean.TRUE.equals(dto.getSetClient())) {
            this.addElement(null, "sc");
            actionSet = true;
        }
        if (!actionSet && Boolean.TRUE.equals(dto.getAddClient())) {
            this.addElement(null, "ac");
            actionSet = true;
        }
        if (Boolean.TRUE.equals(dto.getForce())) {
            this.addElement("F", Boolean.TRUE);
        }
        if (Boolean.TRUE.equals(dto.getVersionCheck())) {
            this.addElement("n", Boolean.TRUE);
        }
        if (StringUtils.isNotBlank(timestamp)) {
            this.addElement("i", timestamp);
        }
        if (StringUtils.isNotBlank(dto.getClientName())) {
            this.addElement("c", dto.getClientName());
        }
        if (StringUtils.isNotBlank(dto.getOs())) {
            this.addElement("O", dto.getOs());
        }
        if (dto.getLocationId() != null) {
            this.addElement("L", dto.getLocationId());
        }
        if (StringUtils.isNotBlank(dto.getAddress())) {
            this.addElement("a", dto.getAddress());
        }
        if (StringUtils.isNotBlank(dto.getMode())) {
            this.addElement("m", dto.getMode());
        }
        if (StringUtils.isNotBlank(dto.getSender())) {
            this.addElement("z", dto.getSender());
        }
        if (StringUtils.isNotBlank(dto.getSesamPackage())) {
            this.addElement("s", dto.getSesamPackage());
        }
        if (Boolean.TRUE.equals(dto.getRunAsUser())) {
            this.addElement("k", Boolean.TRUE);
        }
        if (Boolean.TRUE.equals(dto.getWithBsr())) {
            this.addElement("o", "bsr=yes");
        }
        if (Boolean.TRUE.equals(dto.getWithClient())) {
            this.addElement("o", "client=yes");
        }
        if (Boolean.TRUE.equals(dto.getWithClient())) {
            this.addElement("o", "gui=yes");
        }
        if (queue && !Boolean.TRUE.equals(dto.getSync())) {
            this.addElement("q", Boolean.TRUE);
        }
        if (StringUtils.isNotEmpty(dto.getUrl())) {
            this.addElement("u", dto.getUrl());
        }
    }

    public void setSMConfigDrives(Long driveNum, DSDriveMode dsDriveMode) {
        this.clear();
        if (driveNum == null) {
            this.addElement("", "");
        } else {
            this.addElement("", String.valueOf(driveNum));
        }
        if (dsDriveMode != null && !DSDriveMode.NONE.equals((Object)dsDriveMode)) {
            this.addElement("", dsDriveMode.toString());
        }
    }

    public void setSMConfigLoaders(Long actLoader) {
        this.clear();
        if (actLoader == null) {
            this.addElement("", "");
        } else {
            this.addElement("", String.valueOf(actLoader));
        }
    }

    public void setSMDailySchedule(String scheduleName, String date) {
        assert (StringUtils.isNotBlank(scheduleName));
        this.clear();
        this.addElement("", scheduleName);
        if (StringUtils.isNotBlank(date)) {
            this.addElement("", date);
        }
    }

    public void setSMDatastore(String action, String ssid, String driveNum, String dataStore, String mediumLabel, String noAction, String force, boolean genMode, String backupType, String callerId, String restoreId, String client, String mountPath, String options) {
        this.clear();
        this.addElement("", action);
        this.addElement("s", ssid);
        this.addElement("d", driveNum);
        this.addElement("L", dataStore);
        this.addElement("t", mediumLabel);
        this.addElement("n", noAction);
        this.addElement("o", force);
        this.addElement("b", backupType);
        this.addElement("I", restoreId);
        this.addElement("u", callerId);
        this.addElement("c", client);
        this.addElement("M", mountPath);
        if (genMode) {
            this.addElement("o", "gen");
        }
        if (StringUtils.isNotBlank(options)) {
            this.addAllElements(TextUtils.splitByWhitespaceNotInQuoteOrList(options));
        }
    }

    public void setSMDrive(String keyword, Long driveNum, String option) {
        this.clear();
        this.addElement("", keyword);
        this.addElement("", driveNum);
        this.addElement("", option);
    }

    public void setSMDriveSts(String P1, String P2, String P3) {
        this.clear();
        this.addElement("", P1);
        this.addElement("", P2);
        this.addElement("", P3);
    }

    public void setSMInfo(String P1, String P2, String P3) {
        this.clear();
        this.addElement("", P1);
        this.addElement("", P2);
        this.addElement("", P3);
    }

    public void setSMInventory(Long loaderNumber, String mediaPool, Long driveNumber, String action, String volumeType, String slotArea, Boolean labelFlag, Boolean fastMode, String driveGroup, String storagePoolLocation, String verbose, Boolean adjustWithBarcode) {
        this.clear();
        this.addElement("l", loaderNumber);
        this.addElement("m", mediaPool);
        this.addElement("d", driveNumber);
        this.addElement("i", action);
        this.addElement("t", volumeType);
        this.addElement("s", slotArea);
        this.addElement("c", labelFlag);
        this.addElement("f", fastMode);
        this.addElement("G", driveGroup);
        this.addElement("L", storagePoolLocation);
        this.addElement("v", verbose);
        this.addElement("n", this.convert(adjustWithBarcode));
    }

    public void setSMLoader(SMLoaderAction action, Long loaderNumber, String driveNumber, String port, String slotNumberOrLabel, String option, String storeLocation, String logFile, String verbose) {
        this.clear();
        this.addElement("", action.name());
        if (loaderNumber != null) {
            this.addElement("l", loaderNumber);
        }
        if (StringUtils.isNotBlank(driveNumber)) {
            this.addElement("d", driveNumber);
        }
        if (StringUtils.isNotBlank(port)) {
            this.addElement("p", port);
        }
        this.addElement("s", slotNumberOrLabel);
        this.addElement("o", option);
        this.addElement("L", storeLocation);
        this.addElement("P", logFile);
        this.addElement("v", verbose);
    }

    public void setSMRExec(String outFile, String errFile, String verbose, String hostName, String P1, String P2, String P3) {
        this.clear();
        this.addElement("L", outFile);
        this.addElement("E", errFile);
        this.addElement("v", verbose);
        this.addElement("", hostName);
        this.addElement("", P1);
        this.addElement("", P2);
        this.addElement("", P3);
    }

    public void setSMRecover(String action, String driveNum, String file, String outputFile, String task, String sepuler, String password, String targetPath, String verboseLevelSBC, String verboseLevelSMRecover, Boolean unattendedMode) {
        this.clear();
        this.addElement("", action);
        this.addElement("d", driveNum);
        this.addElement("f", file);
        this.addElement("F", outputFile);
        this.addElement("j", task);
        this.addElement("o", sepuler);
        this.addElement("P", password);
        this.addElement("R", targetPath);
        this.addElement("v", verboseLevelSBC);
        this.addElement("V", verboseLevelSMRecover);
        if (unattendedMode == null || unattendedMode.booleanValue()) {
            unattendedMode = true;
        }
        this.addElement("Y", unattendedMode);
    }

    public void setSMSearchLis(String searchPattern, ExeProcess.SEARCH_TYPE searchType, String client, Date from, Date to, String task) {
        this.clear();
        if (StringUtils.isNotBlank(client)) {
            this.addElement("c", client);
        }
        if (StringUtils.isNotBlank(task)) {
            this.addElement("j", task);
        }
        this.addElement("B", from != null ? DateUtils.dateToDateOnlyStr(from) : "");
        this.addElement("E", to != null ? DateUtils.dateToDateOnlyStr(to) : "");
        this.addElement("q", searchPattern);
        if (searchType != null) {
            this.addElement("o", searchType.toString().toLowerCase());
        }
    }

    public void setSMSetup(String function, String options, String user, String client, String rights, String language, String verbose, boolean ldapEnabled, boolean adEnabled) {
        this.clear();
        this.addElement("", function);
        this.addElement("o", options);
        this.addElement("r", language);
        this.addElement("v", verbose);
        this.addElement("u", user);
        this.addElement("c", client);
        this.addElement("m", rights);
        if ("activate_uac".equals(function)) {
            this.addElement("l", ldapEnabled ? "1" : "0");
            this.addElement("d", adEnabled ? "1" : "0");
        }
    }

    public void setSMSho(String p1, String task, String saveset, String taskType, String taskTypeOption, String option, String p2, String p3, String p4, String p5, Long credentialsId, String additionalOptions) {
        this.clear();
        this.addElement("", p1);
        this.addElement("j", task);
        this.addElement("s", saveset);
        this.addElement("t", taskType);
        this.addElement("a", taskTypeOption);
        this.addElement("o", option);
        if (credentialsId != null) {
            this.addElement("o", "credential=" + credentialsId + (String)(StringUtils.isNotBlank(additionalOptions) ? "," + additionalOptions : ""));
        } else if (StringUtils.isNotBlank(additionalOptions)) {
            this.addElement("o", additionalOptions);
        }
        this.addElement("", p2);
        this.addElement("", p3 != null ? UTF8Utils.convertToUTF8(p3) : "");
        this.addElement("", p4);
        this.addElement("", p5);
    }

    public void setSMLisItems(Boolean searchFlag, String genFlag, String mailFlag, String savesetID, String searchOption, String searchPattern, String dir) {
        this.clear();
        if (Boolean.TRUE.equals(searchFlag) || StringUtils.isNotBlank(searchOption)) {
            this.addElement("S", true);
        }
        this.addElement("G", genFlag);
        this.addElement("M", mailFlag);
        this.addElement("s", savesetID);
        if (StringUtils.isNotBlank(searchPattern)) {
            if (Boolean.TRUE.equals(searchFlag)) {
                this.addElement("o", "f");
                this.addElement("", searchPattern);
            } else {
                this.addElement("o", searchPattern);
            }
        }
        if (StringUtils.isNotBlank(dir) || StringUtils.isNotBlank(searchOption)) {
            this.addElement("", StringUtils.isNotBlank(dir) ? dir : searchOption);
        }
    }

    public void setSMPrepareVMDK(String action, String client, String backupType, String mountPath, String saveset, String nfsInterface, String vCenter, Collection<String> drives, String restoreId, String esxServer, String mount, boolean genMode, String options) {
        this.clear();
        this.addElement("", action);
        this.addElement("c", client);
        this.addElement("b", backupType);
        this.addElement("M", mountPath);
        this.addElement("s", saveset);
        this.addElement("S", nfsInterface);
        this.addElement("I", restoreId);
        this.addElement("V", vCenter);
        this.addElement("E", esxServer);
        this.addElement("o", mount);
        if (drives != null) {
            for (String drive : drives) {
                this.addElement("R", drive);
            }
        }
        if (genMode) {
            this.addElement("o", "gen");
        }
        if (StringUtils.isNotBlank(options)) {
            this.addAllElements(TextUtils.splitByWhitespaceNotInQuoteOrList(options));
        }
    }

    public void setSMCopyVM(String action, String restoreTask, String proxy, String client, String restoreTarget, String mode, String restoreId, String saveset, String iFace, String mountDir) {
        this.clear();
        this.addElement("", action);
        this.addElement("r", restoreTask);
        this.addElement("P", proxy);
        this.addElement("c", client);
        this.addElement("s", saveset);
        this.addElement("I", restoreId);
        this.addElement("R", restoreTarget);
        this.addElement("S", iFace);
        this.addElement("o", mode);
        this.addElement("m", mountDir);
    }

    public void setRemoteBrowseDir(String hostName, String path, boolean verbose) {
        this.clear();
        this.addElement("", hostName);
        this.addElement("", "sm_client");
        this.addElement("v", verbose ? "1" : "0");
        this.addElement("f", "D");
        this.addElement("n", path);
    }

    public void setRemoteSMClient(String hostName, String ... args) {
        this.clear();
        this.addElement("", hostName);
        this.addElement("", "sm_client");
        if (ArrayUtils.isNotEmpty(args)) {
            Arrays.stream(args).forEach(arg -> this.addElement("", arg));
        }
    }

    public void setSMSesam(String function, List<String> savesets, String preferredMediaPool, String eol, Long drive, String user, String label, boolean singleSaveset, String locationName, String clientName, String taskname, String backupId, boolean purge) {
        this.clear();
        this.addElement("", function);
        boolean adjustEol = function.equals("adjust_eol");
        if (!adjustEol && CollectionUtils.isNotEmpty(savesets) && !StringUtils.equals("remove_saveset", function)) {
            this.addElement("s", savesets.get(0));
        }
        this.addElement("m", preferredMediaPool);
        this.addElement("E", eol);
        this.addElement("d", drive);
        this.addElement("t", label);
        this.addElement("u", StringUtils.trim(user));
        if (locationName != null) {
            this.addElement("L", locationName);
        }
        if (clientName != null) {
            this.addElement("c", clientName);
        }
        if (taskname != null) {
            this.addElement("j", taskname);
        }
        if (adjustEol) {
            if (singleSaveset) {
                this.addElement("o", "single_saveset");
            }
            if (CollectionUtils.isNotEmpty(savesets)) {
                for (String saveset : savesets) {
                    this.addElement("", saveset);
                }
            }
        }
        if (StringUtils.equals("remove_saveset", function)) {
            if (StringUtils.isNotBlank(backupId)) {
                this.addElement("B", backupId);
            } else if (CollectionUtils.isNotEmpty(savesets)) {
                this.addElement("s", savesets.get(0));
            }
            if (purge) {
                this.addElement("o", "purge");
            }
        }
    }

    public void setSMGlbv(String command, String name, String value) {
        this.clear();
        this.addElement("", command);
        this.addElement("", name);
        this.addElement("", value);
    }

    public void setHtml2Pdf(String inputFile, String outputFile, String orientation, String paperSize, String zoom) {
        this.clear();
        if (StringUtils.equalsAnyIgnoreCase(orientation, "Landscape", "Portrait")) {
            this.addElement("O", StringUtils.equalsIgnoreCase(orientation, "Landscape") ? "Landscape" : "Portrait");
        }
        this.addElement("s", paperSize);
        this.addElement("--zoom", zoom);
        this.addElement(null, inputFile);
        this.addElement(null, outputFile);
    }

    private String convert(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? "1" : "0";
    }
}

