/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.exec.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.sep.sesam.common.text.TextUtils;
import de.sep.sesam.model.core.AbstractSerializableObject;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

@Schema(description="Information about the executed command")
public class ExeInfo
extends AbstractSerializableObject {
    @JsonIgnore
    private static final long serialVersionUID = -4357509174175249619L;
    @Schema(description="The command executed. This is the original command as it was passed to the remote exec service. ", example="\"sm_gui_request\" \"sm_update_client\" \"cu\" \"-C\" \"r\" \"-c\" \"SesamClient\",")
    private String command;
    @Schema(description="The input to send to the command's STDIN or <code>null</code>.", example="input")
    private String input;
    @Schema(description="The list of commands which need to be executed.", example="[\"sm_gui_request\", \"sm_update_client\", \"cu\", \"-C\", \"r\", \"-c\", \"SesamClient\"]")
    @JsonIgnore
    private List<String> commandList;
    @Schema(description="The return value", example="\"STATUS=SUCCESS MSG=\\0\\\"\"")
    private String retVal;
    @Schema(description="The error message", example="\"ERROR=1000 MSG=\\0\\\"\"")
    private String errorMessage;
    @Schema(description="The exit code", example="0", defaultValue="-1")
    private Integer exitCode = -1;

    public void setCommand(String command) {
        this.command = command;
        this.commandList = TextUtils.splitByWhitespaceNotInQuoteOrList(command).stream().map(c -> StringUtils.removeEnd(StringUtils.removeStart(StringUtils.trim(c), "\""), "\"")).collect(Collectors.toList());
    }

    @JsonIgnore
    public void setCommandFromList(List<String> commandList) {
        assert (commandList != null);
        this.commandList = commandList;
        this.command = CollectionUtils.isNotEmpty(commandList) ? commandList.stream().map(c -> StringUtils.contains((CharSequence)c, " ") ? "\"" + StringUtils.removeEnd(StringUtils.removeStart(StringUtils.trim(c), "\""), "\"") + "\"" : c).collect(Collectors.joining(" ")) : null;
    }

    @JsonIgnore
    public String getQuotedCommand() {
        StringBuilder sb = new StringBuilder();
        if (this.commandList != null) {
            Iterator<String> it = this.commandList.iterator();
            while (it.hasNext()) {
                String value = "\"" + it.next() + "\"";
                sb.append(value);
                if (!it.hasNext()) continue;
                sb.append(" ");
            }
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    @JsonIgnore
    public String getOutputWithError() {
        return this.getErrorMessage() + "\n\n" + this.getRetVal();
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public String getInput() {
        return this.input;
    }

    @Generated
    public String getRetVal() {
        return this.retVal;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public Integer getExitCode() {
        return this.exitCode;
    }

    @Generated
    public void setInput(String input) {
        this.input = input;
    }

    @Generated
    public void setRetVal(String retVal) {
        this.retVal = retVal;
    }

    @Generated
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    @Generated
    public ExeInfo() {
    }
}

