/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static byte[] gunzip(File inputFile) throws IOException {
        assert (inputFile != null);
        byte[] content = null;
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             GZIPInputStream gzipper = new GZIPInputStream(new FileInputStream(inputFile));){
            int len;
            while ((len = gzipper.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            content = out.toByteArray();
        }
        return content;
    }

    public static void gzip(String inputFile, String outputFile) throws IOException {
        assert (inputFile != null);
        if (outputFile == null) {
            outputFile = inputFile + ".gz";
        }
        byte[] buffer = new byte[1024];
        try (GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream((String)outputFile));
             FileInputStream in = new FileInputStream(inputFile);){
            int len;
            while ((len = in.read(buffer)) > 0) {
                gzos.write(buffer, 0, len);
            }
            gzos.finish();
        }
    }

    public static void zipFiles(List<String> srcFiles, String outputFile, boolean absolutePath) throws IOException {
        assert (srcFiles != null);
        byte[] buffer = new byte[1024];
        FileOutputStream fos = new FileOutputStream(outputFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        try {
            for (String srcFile : srcFiles) {
                File f = new File(srcFile);
                if (!f.exists() || !f.isFile()) continue;
                FileInputStream fis = null;
                try {
                    int length;
                    fis = new FileInputStream(srcFile);
                    if (absolutePath) {
                        zos.putNextEntry(new ZipEntry(srcFile));
                    } else {
                        zos.putNextEntry(new ZipEntry(new File(srcFile).getName()));
                    }
                    while ((length = fis.read(buffer)) > 0) {
                        zos.write(buffer, 0, length);
                    }
                }
                catch (IOException e) {
                    throw e;
                }
                finally {
                    zos.closeEntry();
                    fis.close();
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            zos.close();
            fos.close();
        }
    }

    public static byte[] unCompressByte(byte[] content) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            GZIPInputStream in = new GZIPInputStream(bis);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) >= 0) {
                bos.write(buffer, 0, len);
            }
            in.close();
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }
}

