/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class UTF8Utils {
    public static String convertToUTF8(String input) {
        if (StringUtils.isBlank(input)) {
            return input;
        }
        if (StringUtils.equals(input, StringUtils.toEncodedString(input.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8))) {
            return input;
        }
        return UTF8Utils.convertToUTF8(input.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.ISO_8859_1);
    }

    public static String convertToUTF8(byte[] bytes, Charset charset) {
        if (ArrayUtils.isEmpty(bytes)) {
            return null;
        }
        Charset cs = charset != null ? charset : StandardCharsets.UTF_8;
        String encodedString = StringUtils.toEncodedString(bytes, cs);
        byte[] utf8Bytes = StringUtils.getBytes(encodedString, StandardCharsets.UTF_8);
        if (utf8Bytes != null && utf8Bytes.length >= 3 && StringUtils.equals(Hex.encodeHexString(ArrayUtils.subarray(utf8Bytes, 0, 3)), "efbbbf")) {
            utf8Bytes = ArrayUtils.subarray(utf8Bytes, 3, utf8Bytes.length);
        }
        return StringUtils.toEncodedString(utf8Bytes, StandardCharsets.UTF_8);
    }
}

