/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.util;

import de.sep.sesam.common.text.TextUtils;
import java.io.IOException;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;

public final class HostUtils {
    private static String hostname;

    public static boolean isWindowsHost() {
        return StringUtils.startsWith(System.getProperty("os.name"), "Windows");
    }

    public static String getHostname() {
        if (StringUtils.isNotBlank(hostname)) {
            return hostname;
        }
        hostname = HostUtils.exec("hostname");
        if (StringUtils.isBlank(hostname)) {
            hostname = System.getenv(HostUtils.isWindowsHost() ? "COMPUTERNAME" : "HOSTNAME");
        }
        hostname = StringUtils.trim(hostname);
        return hostname;
    }

    private static String exec(String execCommand) {
        assert (execCommand != null);
        String str = "";
        try (Scanner s = new Scanner(Runtime.getRuntime().exec(execCommand).getInputStream());){
            s.useDelimiter("\\A");
            if (s.hasNext()) {
                str = s.next();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return str;
    }

    public static String getenv(String name) {
        return TextUtils.replaceVariables(System.getenv(name));
    }

    public static String getProperty(String name) {
        return TextUtils.replaceVariables(System.getProperty(name));
    }
}

