/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.text;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;

public final class TextUtils {
    private static final StringSubstitutor interpolator;
    private static final Map<String, String> launchEnvironment;

    public static String maskNewlinesInQuotes(String text) {
        String maskedText = text;
        if (StringUtils.isNotBlank(text)) {
            boolean inQuotes = false;
            StringBuilder b = new StringBuilder();
            block6: for (char c : text.toCharArray()) {
                switch (c) {
                    case '\t': {
                        if (inQuotes) {
                            b.append("\\t");
                            continue block6;
                        }
                        b.append(c);
                        continue block6;
                    }
                    case '\n': {
                        if (inQuotes) {
                            b.append("\\n");
                            continue block6;
                        }
                        b.append(c);
                        continue block6;
                    }
                    case '\r': {
                        if (inQuotes) {
                            b.append("\\r");
                            continue block6;
                        }
                        b.append(c);
                        continue block6;
                    }
                    case '\"': {
                        inQuotes = c == '\"' != inQuotes;
                    }
                    default: {
                        b.append(c);
                    }
                }
            }
            maskedText = b.toString();
        }
        return maskedText;
    }

    public static List<String> splitByCommaNotInQuoteOrList(String value) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (StringUtils.isNotBlank(value)) {
            boolean inQuotes = false;
            boolean inList = false;
            StringBuilder b = new StringBuilder();
            block4: for (char c : value.toCharArray()) {
                switch (c) {
                    case ',': {
                        if (inQuotes || inList) {
                            b.append(c);
                            continue block4;
                        }
                        tokens.add(b.toString());
                        b = new StringBuilder();
                        continue block4;
                    }
                    case '\"': 
                    case '\'': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        inQuotes = (c == '\"' || c == '\'') != inQuotes;
                        inList = (c != '\"' && c != '\'') != inList;
                    }
                    default: {
                        b.append(c);
                    }
                }
            }
            tokens.add(b.toString());
        }
        return tokens;
    }

    public static List<String> splitByWhitespaceNotInQuoteOrList(String value) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (StringUtils.isNotBlank(value)) {
            boolean inQuotes = false;
            boolean inList = false;
            StringBuilder b = new StringBuilder();
            block4: for (char c : value.toCharArray()) {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (inQuotes || inList) {
                            b.append(c);
                            continue block4;
                        }
                        tokens.add(b.toString());
                        b = new StringBuilder();
                        continue block4;
                    }
                    case '\"': 
                    case '[': 
                    case ']': {
                        inQuotes = c == '\"' != inQuotes;
                        inList = c != '\"' != inList;
                    }
                    default: {
                        b.append(c);
                    }
                }
            }
            tokens.add(b.toString());
        }
        return tokens;
    }

    public static String maskRegularExpressionCharacters(String pattern) {
        String v = pattern;
        if (StringUtils.isNotBlank(v)) {
            v = v.replace("^", "\\^");
            v = v.replace("$", "\\$");
            v = v.replace(".", "\\.");
            v = v.replace("[", "\\[");
            v = v.replace("]", "\\]");
            v = v.replace("|", "\\|");
            v = v.replace("(", "\\(");
            v = v.replace(")", "\\)");
            v = v.replace("?", "\\?");
            v = v.replace("*", "\\*");
            v = v.replace("+", "\\+");
            v = v.replace("{", "\\{");
            v = v.replace("}", "\\}");
        }
        return v;
    }

    public static String maskListCharacters(String value) {
        String v = value;
        if (StringUtils.isNotBlank(value)) {
            v = v.replace("[", "&sbl;");
            v = v.replace("]", "&sbr;");
            v = v.replace("{", "&cbl;");
            v = v.replace("}", "&cbr;");
            v = v.replace("'", "&sqout;");
            v = v.replace(" ", "\u00a0");
        }
        return v;
    }

    public static String unmaskListCharacters(String value) {
        String v = value;
        if (StringUtils.isNotBlank(value)) {
            v = v.replace("&sbl;", "[");
            v = v.replace("&sbr;", "]");
            v = v.replace("&cbl;", "{");
            v = v.replace("&cbr;", "}");
            v = v.replace("&sqout;", "'");
            v = v.replace("\u00a0", " ");
        }
        return v;
    }

    public static String replaceCharNotInQuotesOrBraces(String text, char searchChar, char replacement) {
        String newText = text;
        if (StringUtils.isNotBlank(text)) {
            boolean inQuotes = false;
            int braceCount = 0;
            StringBuilder b = new StringBuilder();
            for (char c : text.toCharArray()) {
                switch (c) {
                    case '{': {
                        ++braceCount;
                        break;
                    }
                    case '}': {
                        --braceCount;
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        boolean bl = inQuotes = (c == '\"' || c == '\'') != inQuotes;
                    }
                }
                if (c == searchChar && !inQuotes && braceCount == 0) {
                    b.append(replacement);
                    continue;
                }
                b.append(c);
            }
            newText = b.toString();
        }
        return newText;
    }

    public static String replaceVariables(String source) {
        if (StringUtils.isBlank(source)) {
            return source;
        }
        if (!Boolean.getBoolean("java.text-utils.launch-env.loaded")) {
            TextUtils.loadLaunchEnvironment();
        }
        assert (interpolator != null);
        return interpolator.replace(source);
    }

    private static void loadLaunchEnvironment() {
        System.setProperty("java.text-utils.launch-env.loaded", "true");
        String lookupPath = null;
        try {
            lookupPath = TextUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        String path = null;
        if (StringUtils.isNotBlank(lookupPath)) {
            path = StringUtils.removeEnd(lookupPath, "/classes/");
            Path p = new File(path).toPath().normalize();
            if (StringUtils.endsWith(p.getFileName().toString(), "-SNAPSHOT.jar")) {
                path = p.getParent().toString();
            }
            path = StringUtils.removeEnd(path, "/sep-utils/target");
            path = path.concat("/build/environments/launch-common.env");
        }
        if (StringUtils.isNotBlank(path)) {
            try (FileReader reader = new FileReader(path);){
                Properties env = new Properties();
                assert (env != null);
                env.load(reader);
                if (!env.isEmpty()) {
                    env.stringPropertyNames().forEach(k -> launchEnvironment.put((String)k, env.getProperty((String)k)));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String[] replaceVariables(String[] sources) {
        if (ArrayUtils.isEmpty(sources)) {
            return sources;
        }
        return (String[])Arrays.stream(sources).map(TextUtils::replaceVariables).toArray(String[]::new);
    }

    public static String normalizeSpecial(String s) {
        if (StringUtils.isBlank(s)) {
            return s;
        }
        return StringUtils.equals(s, "TO_NULL") ? null : (StringUtils.equals(s, "TO_EMPTY") ? "" : s);
    }

    public static String quote(String input) {
        if (StringUtils.isBlank(input)) {
            return input;
        }
        Object output = input;
        if (StringUtils.contains((CharSequence)output, " ")) {
            output = "\"" + StringUtils.replace(StringUtils.removeStart(StringUtils.removeEnd((String)output, "\""), "\""), "\"", "\\\"") + "\"";
        }
        return output;
    }

    static {
        launchEnvironment = new HashMap<String, String>();
        StringLookup lookup = key -> {
            String value;
            String transformation = null;
            if (StringUtils.endsWithAny(StringUtils.lowerCase(key), ".lower", ".upper")) {
                transformation = StringUtils.endsWithIgnoreCase(key, ".lower") ? "lower" : "upper";
                key = StringUtils.removeEnd(StringUtils.removeEndIgnoreCase(key, ".lower"), ".upper");
            }
            if (StringUtils.isBlank(value = StringLookupFactory.INSTANCE.environmentVariableStringLookup().lookup(key)) && launchEnvironment.containsKey(key)) {
                value = launchEnvironment.get(key);
            }
            return StringUtils.equals(transformation, "lower") ? StringUtils.lowerCase(value) : (StringUtils.equals(transformation, "upper") ? StringUtils.upperCase(value) : StringUtils.trim(value));
        };
        interpolator = new StringSubstitutor(StringLookupFactory.INSTANCE.interpolatorStringLookup(lookup));
        interpolator.setEnableSubstitutionInVariables(true);
    }
}

