/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.text;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class TextEncoder {
    public static String urlEncode(String text) {
        if (StringUtils.isBlank(text)) {
            return text;
        }
        String encoded = URLEncoder.encode(text, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
        StringBuilder retVal = new StringBuilder();
        if (StringUtils.isNotBlank(encoded)) {
            for (int i = 0; i < encoded.length(); ++i) {
                char c = encoded.charAt(i);
                if (c == '+') {
                    retVal.append(" ");
                    continue;
                }
                if (c == '%' && encoded.length() >= i + 2) {
                    String sub = encoded.substring(i, i + 3).toLowerCase();
                    retVal.append(sub);
                    i += 2;
                    continue;
                }
                retVal.append(c);
            }
        }
        return retVal.toString();
    }

    public static String urlDecode(String text) {
        String decoded;
        if (StringUtils.isBlank(text)) {
            return text;
        }
        try {
            String s = StringUtils.replace(text, "+", "__PLUS__");
            decoded = URLDecoder.decode(s, StandardCharsets.UTF_8);
            decoded = StringUtils.replace(decoded, "__PLUS__", "+");
        }
        catch (IllegalArgumentException e) {
            decoded = text;
        }
        return decoded;
    }

    @Generated
    private TextEncoder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

