/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.text;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public final class I18n {
    private static final Map<Locale, Map<String, String>> messages = new HashMap<Locale, Map<String, String>>();
    private static boolean initialized = false;

    public static String get(String key, Object ... values) {
        assert (key != null);
        return I18n.format(key, I18n.internalGet(key, null), values);
    }

    public static String getByLocale(String key, Locale locale, Object ... values) {
        assert (key != null);
        assert (locale != null);
        return I18n.format(key, I18n.internalGet(key, locale), values);
    }

    public static String translate(String module, String key, Locale locale, Object ... values) {
        assert (module != null);
        String m = key;
        if (!(m == null || "".equals(m.trim()) || m.contains(" ") || m.contains("\t") || m.contains("\n") || m.contains("\f") || m.contains("\r"))) {
            String m2;
            String k = module.trim() + "." + m.trim();
            String string = m2 = locale != null ? I18n.getByLocale(k, locale, values) : I18n.get(k, values);
            if (m2 != null && !"".equals(m2.trim()) && !("!" + k + "!").equals(m2)) {
                m = m2;
            }
        }
        return m;
    }

    private static String format(String key, String m, Object ... values) {
        assert (key != null);
        if (m != null && values != null && values.length > 0) {
            return MessageFormat.format(m, values);
        }
        return m != null ? m : "!" + key + "!";
    }

    private static String internalGet(String key, Locale locale) {
        Locale l;
        assert (key != null);
        Locale locale2 = l = locale != null ? locale : Locale.getDefault();
        assert (l != null);
        if ("en".equalsIgnoreCase(l.getLanguage())) {
            l = Locale.forLanguageTag("");
        }
        assert (l != null);
        Map<String, String> map = I18n.getMessages(l);
        if (map == null) {
            map = I18n.getMessages(Locale.getDefault());
        }
        assert (map != null);
        String msg = map.get(key);
        if (msg != null) {
            return msg;
        }
        if (key.indexOf(46) != -1) {
            return map.get(key.replace('.', '_'));
        }
        return null;
    }

    private static Map<String, String> getMessages(Locale locale) {
        assert (locale != null);
        Map<String, String> map = messages.get(locale);
        if (map == null) {
            map = new HashMap<String, String>();
            ResourceBundle bundle = ResourceBundle.getBundle("translation", locale, I18n.class.getClassLoader());
            if (!bundle.getLocale().getLanguage().equals(locale.getLanguage())) {
                return map;
            }
            messages.put(locale, map);
            Map<String, String> finalMap = map;
            bundle.keySet().forEach(k -> finalMap.put((String)k, bundle.getString((String)k)));
        }
        return map;
    }

    public static boolean containsKey(String key) {
        assert (key != null);
        return I18n.internalGet(key, null) != null;
    }

    public static void reload() {
        initialized = false;
        messages.clear();
        I18n.init();
    }

    private static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        I18n.getMessages(Locale.getDefault());
    }

    public static Locale resolveLocale(String language) {
        Locale locale = null;
        if (language != null && !language.trim().isEmpty()) {
            locale = Locale.forLanguageTag(language);
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    static {
        I18n.init();
    }
}

