/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.security;

import java.io.IOException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLUtils {
    private static SSLSocketFactory socketFactory = null;
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public static String getSSLThumbPrint(String server) throws UnknownHostException, IOException, NoSuchAlgorithmException, KeyManagementException, CertificateEncodingException {
        if (socketFactory == null) {
            SSLUtils.initTrustManager();
        }
        SSLSocket sslSocket = (SSLSocket)socketFactory.createSocket(server, 443);
        sslSocket.setSoTimeout(10000);
        sslSocket.startHandshake();
        SSLSession session = sslSocket.getSession();
        HandshakeCompletedEvent event = new HandshakeCompletedEvent(sslSocket, session);
        Certificate[] vCenterServerCert = event.getPeerCertificates();
        if (vCenterServerCert != null && vCenterServerCert.length > 0) {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] der = vCenterServerCert[0].getEncoded();
            md.update(der);
            return SSLUtils.getThumbPrint(vCenterServerCert[0]);
        }
        return null;
    }

    public static void initTrustManager() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.getServerSessionContext().setSessionTimeout(0);
        sslContext.init(null, trustAllCerts, new SecureRandom());
        socketFactory = sslContext.getSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
        HttpsURLConnection.setDefaultHostnameVerifier((urlHostName, session) -> true);
    }

    private static String getThumbPrint(Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        return SSLUtils.toHexString(digest);
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[n & 0xF]);
            sb.append(':');
        }
        String ret = sb.toString().toUpperCase();
        return ret.substring(0, ret.length() - 1);
    }
}

