/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.security;

import BlowfishJ.BlowfishEasy;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.MalformedInputException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;

public final class EncryptUtils {
    private static final String version = "md501";
    private static final EncryptUtils instance;
    private static final byte[] SALT;

    private EncryptUtils() {
    }

    public static EncryptUtils getInstance() {
        return instance;
    }

    private char[] getKey() {
        BlowfishEasy blow = new BlowfishEasy("");
        char[] ky = blow.decryptString(new String(SALT)).toCharArray();
        blow.destroy();
        return ky;
    }

    public String encrypt(String sCipherText) {
        return this.encrypt(this.getKey(), sCipherText);
    }

    public String encrypt(char[] password, String sCipherText) {
        assert (password != null);
        if (StringUtils.equalsAny(sCipherText, "TO_NULL", "TO_EMPTY")) {
            return sCipherText;
        }
        String data = "";
        if (StringUtils.isNotBlank(sCipherText)) {
            BlowfishEasy bfe = new BlowfishEasy(String.valueOf(password));
            data = bfe.encryptString(this.utf8BackConverter(sCipherText));
            bfe.destroy();
        }
        return data;
    }

    public String decrypt(String sCipherText) {
        return this.decrypt(this.getKey(), sCipherText);
    }

    public String decrypt(char[] password, String sCipherText) {
        assert (password != null);
        String data = "";
        if (StringUtils.isNotBlank(sCipherText)) {
            BlowfishEasy bfe = new BlowfishEasy(String.valueOf(password));
            data = bfe.decryptString(sCipherText);
            bfe.destroy();
            if (StringUtils.isNotBlank(data)) {
                data = EncryptUtils.utf8converter(data);
            }
        }
        return data;
    }

    public static String utf8converter(String input) {
        if (StringUtils.isBlank(input)) {
            return input;
        }
        Charset charsetIso = Charset.forName("ISO-8859-1");
        Charset charsetUtf8 = Charset.forName("UTF-8");
        CharsetDecoder decoderUtf8 = charsetUtf8.newDecoder();
        String subString = input;
        ByteBuffer bbuf = charsetIso.encode(subString);
        CharBuffer cbuf = null;
        try {
            cbuf = decoderUtf8.decode(bbuf);
        }
        catch (MalformedInputException e) {
            return subString;
        }
        catch (Exception e) {
            return subString;
        }
        String retVal = cbuf.toString();
        return retVal == null || retVal.length() == 0 ? subString : retVal;
    }

    private String utf8BackConverter(String msg) {
        Charset charsetIso = Charset.forName("ISO-8859-1");
        Charset charsetUtf8 = Charset.forName("UTF-8");
        CharsetDecoder decoderISO = charsetIso.newDecoder();
        String subString = msg;
        ByteBuffer bbuf = charsetUtf8.encode(subString);
        CharBuffer cbuf = null;
        try {
            cbuf = decoderISO.decode(bbuf);
        }
        catch (MalformedInputException e) {
            return subString;
        }
        catch (Exception e) {
            return subString;
        }
        String retVal = cbuf.toString();
        return retVal == null || retVal.length() == 0 ? subString : retVal;
    }

    public String encryptPWWithVersionMD5(char[] password) {
        String pw = String.valueOf(password);
        return this.encryptPWWithVersionMD5(pw);
    }

    public String encryptPWWithVersionMD5(String pw) {
        if (pw == null || pw.length() == 0) {
            return "";
        }
        StringBuilder hexString = new StringBuilder();
        byte[] defaultBytes = pw.getBytes();
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(defaultBytes);
            byte[] messageDigest = algorithm.digest();
            for (int i = 0; i < messageDigest.length; ++i) {
                String hex = Integer.toHexString(0xFF & messageDigest[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
        }
        catch (NoSuchAlgorithmException algorithm) {
            // empty catch block
        }
        String data = hexString.toString();
        String retVal = "md501{" + data + "}";
        return retVal;
    }

    static {
        SALT = new byte[]{52, 98, 55, 51, 53, 55, 53, 55, 55, 100, 99, 102, 101, 48, 51, 54, 100, 50, 102, 101, 98, 53, 99, 53, 57, 97, 52, 56, 97, 51, 101, 53, 97, 52, 49, 53, 50, 52, 53, 51, 52, 49, 101, 52, 52, 56, 99, 100, 101, 55, 50, 101, 102, 51, 50, 52, 54, 101, 101, 57, 49, 101, 101, 100};
        instance = new EncryptUtils();
    }
}

