/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.security;

import de.sep.sesam.common.ini.IniUtils;
import de.sep.sesam.common.ini.SesamIni;
import de.sep.sesam.common.util.HostUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CertificateUtils {
    private static File getSystemSslPath() {
        File iniPath;
        File path = null;
        String gv_ro_ssl = SesamIni.getInstance().get("PATHES", "gv_ro_ssl");
        if (StringUtils.isNotBlank(gv_ro_ssl)) {
            path = new File(gv_ro_ssl);
        }
        if (path == null && (iniPath = IniUtils.findIniPath()) != null) {
            path = new File(iniPath.getParentFile(), "ssl");
        }
        if (path != null && !path.exists()) {
            path.mkdir();
        }
        return path;
    }

    public static File getUserAuthenticationCertificatePath() {
        File path = null;
        String gv_ro_ssl_auth = SesamIni.getInstance().get("PATHES", "gv_ro_ssl_auth");
        if (StringUtils.isNotBlank(gv_ro_ssl_auth)) {
            path = new File(gv_ro_ssl_auth);
        }
        return path != null ? path : CertificateUtils.getSystemSslPath();
    }

    private static File getDbAuthenticationCertificatePath() {
        File path = null;
        String gv_ro_ssl_auth = SesamIni.getInstance().get("PATHES", "gv_ro_ssl_db");
        if (StringUtils.isNotBlank(gv_ro_ssl_auth)) {
            path = new File(gv_ro_ssl_auth);
        }
        return path != null ? path : CertificateUtils.getSystemSslPath();
    }

    private static File getHttpsCertificatePath() {
        File path = null;
        String gv_ro_ssl_https = SesamIni.getInstance().get("PATHES", "gv_ro_ssl_https");
        if (StringUtils.isNotBlank(gv_ro_ssl_https)) {
            path = new File(gv_ro_ssl_https);
        }
        return path != null ? path : CertificateUtils.getSystemSslPath();
    }

    public static File getUserAuthenticationCertificateFile() {
        File f;
        File path = CertificateUtils.getUserAuthenticationCertificatePath();
        File file = f = path != null ? new File(path, "sesam.gui.cert") : null;
        if (f != null && f.canRead()) {
            boolean canWrite;
            boolean bl = HostUtils.isWindowsHost() ? f.canWrite() : (canWrite = f.getParentFile() != null && f.getParentFile().canWrite());
            if (canWrite) {
                try {
                    f.renameTo(new File(path, "sesam.auth.crt"));
                    f = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (f == null || !f.canRead()) {
            f = path != null ? new File(path, "sesam.auth.crt") : null;
        }
        return f;
    }

    public static File getSlaveAuthenticationCertificateFile() {
        File path = CertificateUtils.getUserAuthenticationCertificatePath();
        return path != null ? new File(path, "sesam.cluster.crt") : null;
    }

    public static File getUserAuthenticationPrivateKeyFile() {
        File f;
        File path = CertificateUtils.getUserAuthenticationCertificatePath();
        File file = f = path != null ? new File(path, "sesam.gui.key") : null;
        if (f != null) {
            boolean canWrite;
            boolean bl = HostUtils.isWindowsHost() ? f.canWrite() : (canWrite = f.getParentFile() != null && f.getParentFile().canWrite());
            if (canWrite) {
                try {
                    f.renameTo(new File(path, "sesam.auth.key"));
                    f = null;
                    new File(path, "sesam.gui.pk8").delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (f == null || !f.canRead()) {
            f = path != null ? new File(path, "sesam.auth.key") : null;
        }
        return f;
    }

    public static File getSlaveAuthenticationPrivateKeyFile() {
        File path = CertificateUtils.getUserAuthenticationCertificatePath();
        return path != null ? new File(path, "sesam.cluster.key") : null;
    }

    public static File getPrivateKeyFilePk8(File pemKeyFile) {
        if (pemKeyFile == null || !pemKeyFile.canRead()) {
            return null;
        }
        String fileName = pemKeyFile.getName();
        if (StringUtils.indexOf((CharSequence)fileName, ".") > 0) {
            fileName = StringUtils.substring(fileName, 0, StringUtils.lastIndexOf((CharSequence)fileName, "."));
        }
        return new File(pemKeyFile.getParentFile(), fileName + ".pk8");
    }

    public static File getDbAuthenticationCertificateFile() {
        File path = CertificateUtils.getDbAuthenticationCertificatePath();
        return path != null ? new File(path, "sesam.db.crt") : null;
    }

    public static File getDbAuthenticationPrivateKeyFile() {
        File path = CertificateUtils.getDbAuthenticationCertificatePath();
        return path != null ? new File(path, "sesam.db.key") : null;
    }

    public static File getHttpsCertificateFile() {
        File f = CertificateUtils.getHttpsCertificatePath();
        return f != null ? new File(f, "sesam.https.crt") : null;
    }

    public static File getHttpsPrivateKeyFile() {
        File f = CertificateUtils.getHttpsCertificatePath();
        return f != null ? new File(f, "sesam.https.key") : null;
    }

    public static void checkCertificateFilePermissions(File file) {
        if (file == null || !file.canRead()) {
            return;
        }
        Path path = file.toPath();
        assert (path != null);
        FileOwnerAttributeView ownerView = Files.getFileAttributeView(path, FileOwnerAttributeView.class, new LinkOption[0]);
        if (ownerView == null) {
            return;
        }
        UserPrincipal owner = null;
        try {
            owner = Files.getOwner(path, new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!(owner != null && StringUtils.equalsAny(owner.getName(), System.getProperty("user.name"), "sesam") || owner != null && HostUtils.isWindowsHost() && StringUtils.endsWith(owner.getName(), "\\" + System.getProperty("user.name")))) {
            return;
        }
        assert (owner != null);
        if (!StringUtils.equals(owner.getName(), "sesam") && !StringUtils.endsWith(owner.getName(), "\\sesam")) {
            FileSystem fileSystem = path.getFileSystem();
            UserPrincipalLookupService service = fileSystem != null ? fileSystem.getUserPrincipalLookupService() : null;
            try {
                UserPrincipal sesamUser;
                UserPrincipal userPrincipal = sesamUser = service != null ? service.lookupPrincipalByName("sesam") : null;
                if (sesamUser != null) {
                    Files.setOwner(path, sesamUser);
                    owner = Files.getOwner(path, new LinkOption[0]);
                }
            }
            catch (IOException sesamUser) {
                // empty catch block
            }
        }
        if (HostUtils.isWindowsHost()) {
            try {
                file.setExecutable(false);
            }
            catch (Exception fileSystem) {}
        } else {
            PosixFileAttributeView posixView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
            if (posixView == null) {
                return;
            }
            Set<PosixFilePermission> perms = null;
            try {
                perms = Files.getPosixFilePermissions(path, new LinkOption[0]);
            }
            catch (IOException sesamUser) {
                // empty catch block
            }
            if (perms == null || perms.isEmpty()) {
                return;
            }
            HashSet<PosixFilePermission> expectedPerms = new HashSet<PosixFilePermission>();
            expectedPerms.add(PosixFilePermission.OWNER_READ);
            expectedPerms.add(PosixFilePermission.OWNER_WRITE);
            expectedPerms.add(PosixFilePermission.GROUP_READ);
            expectedPerms.add(PosixFilePermission.OTHERS_READ);
            if (CollectionUtils.containsAll(perms, expectedPerms)) {
                return;
            }
            try {
                Files.setPosixFilePermissions(path, expectedPerms);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void checkPrivateKeyFilePermissions(File file) {
        if (file == null || !file.canRead()) {
            return;
        }
        Path path = file.toPath();
        assert (path != null);
        FileOwnerAttributeView ownerView = Files.getFileAttributeView(path, FileOwnerAttributeView.class, new LinkOption[0]);
        if (ownerView == null) {
            return;
        }
        UserPrincipal owner = null;
        try {
            owner = Files.getOwner(path, new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!(owner != null && StringUtils.equalsAny(owner.getName(), System.getProperty("user.name"), "sesam") || owner != null && HostUtils.isWindowsHost() && StringUtils.endsWith(owner.getName(), "\\" + System.getProperty("user.name")))) {
            return;
        }
        assert (owner != null);
        if (!StringUtils.equals(owner.getName(), "sesam") && !StringUtils.endsWith(owner.getName(), "\\sesam")) {
            FileSystem fileSystem = path.getFileSystem();
            UserPrincipalLookupService service = fileSystem != null ? fileSystem.getUserPrincipalLookupService() : null;
            try {
                UserPrincipal sesamUser;
                UserPrincipal userPrincipal = sesamUser = service != null ? service.lookupPrincipalByName("sesam") : null;
                if (sesamUser != null) {
                    Files.setOwner(path, sesamUser);
                    owner = Files.getOwner(path, new LinkOption[0]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (HostUtils.isWindowsHost()) {
            try {
                file.setWritable(false);
                file.setExecutable(false);
            }
            catch (Exception fileSystem) {}
        } else {
            PosixFileAttributeView posixView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
            if (posixView == null) {
                return;
            }
            Set<PosixFilePermission> perms = null;
            try {
                perms = Files.getPosixFilePermissions(path, new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (perms == null || perms.isEmpty()) {
                return;
            }
            if (perms.size() == 1 && perms.contains((Object)PosixFilePermission.OWNER_READ)) {
                return;
            }
            perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            try {
                Files.setPosixFilePermissions(path, perms);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String extractPemString(String certificate) {
        if (StringUtils.isBlank(certificate)) {
            return null;
        }
        String pemString = StringUtils.trim(StringUtils.replace(certificate, "\r\n", "\n"));
        pemString = StringUtils.trim(pemString.replaceAll("[\\s\\S]*-----BEGIN\\s+.*CERTIFICATE-----", ""));
        pemString = StringUtils.trim(pemString.replaceAll("-----END\\s+.*CERTIFICATE-----[\\s\\S]*", ""));
        pemString = StringUtils.trim(StringUtils.replace(pemString, "\n", ""));
        return pemString;
    }
}

