/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.logging;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class UserInfoConverter
extends ClassicConverter {
    private static final Pattern myBatisStatementPattern = Pattern.compile("\\s*<?=+>?\\s*(Preparing|Parameters|Total):.*");

    @Override
    public String convert(ILoggingEvent event) {
        assert (event != null);
        String msg = event.getFormattedMessage();
        if (StringUtils.isNotBlank(msg) && myBatisStatementPattern.matcher(msg).matches()) {
            return "";
        }
        Map<String, String> mdc = event.getMDCPropertyMap();
        if (mdc.containsKey("uid") || mdc.containsKey("uip")) {
            StringBuilder buffer = new StringBuilder("[");
            if (mdc.containsKey("uid")) {
                buffer.append("User: ");
                buffer.append(mdc.get("uid"));
            }
            if (mdc.containsKey("uip")) {
                if (buffer.length() > 1) {
                    buffer.append(", ");
                }
                buffer.append("IP: ");
                buffer.append(mdc.get("uip"));
            }
            buffer.append("]");
            return buffer.toString();
        }
        return "";
    }
}

