/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.logging;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.rolling.RollingFileAppender;
import de.sep.sesam.common.logging.LogContext;
import de.sep.sesam.common.logging.LogGroup;
import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;

public class SepRollingFileAppender<E>
extends RollingFileAppender<E> {
    @Override
    public void doAppend(E eventObject) {
        LogContext ctx = LogContext.getContext();
        if (ctx != null) {
            if (ctx.getSessionId() != null) {
                MDC.put("sid", ctx.getSessionId());
            }
            if (ctx.getUserId() != null) {
                MDC.put("uid", ctx.getUserId());
            }
            if (ctx.getUserIp() != null) {
                MDC.put("uip", ctx.getUserIp());
            }
        }
        if (eventObject instanceof LoggingEvent) {
            LoggingEvent event = (LoggingEvent)eventObject;
            if (event.getThrowableProxy() != null && StringUtils.startsWith(event.getLoggerName(), "com.vmware.vim25") && !StringUtils.contains((CharSequence)event.getFormattedMessage(), "NullPointerException")) {
                try {
                    Field f = LoggingEvent.class.getDeclaredField("throwableProxy");
                    if (f != null) {
                        f.setAccessible(true);
                        f.set(event, null);
                    }
                }
                catch (Exception exception) {}
            } else if (StringUtils.startsWith(event.getLoggerName(), "org.springframework.security")) {
                MDC.put("grouping", LogGroup.SECURITY.toString());
            }
        }
        super.doAppend(eventObject);
    }
}

