/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.logging;

import org.apache.commons.lang3.StringUtils;

public enum SepLogLevel {
    TRACE("Trace:   ", 4),
    DEBUG("Debug:   ", 3),
    INFO("Info:    ", 2),
    EXEC("Exec:    ", 1),
    WARN("Warning: ", 0),
    ERROR("Error:   ", 0),
    FATAL("Fatal:   ", 0);

    private String customName;
    private int num;

    private SepLogLevel(String customName, int iLevel) {
        this.customName = customName;
        this.num = iLevel;
    }

    public static SepLogLevel fromString(String levelString) {
        if (StringUtils.isBlank(levelString)) {
            levelString = "1";
        }
        SepLogLevel level = INFO;
        if (levelString.toUpperCase().matches("TRACE|4")) {
            level = TRACE;
        } else if (levelString.toUpperCase().matches("DEBUG|3")) {
            level = DEBUG;
        } else if (levelString.toUpperCase().matches("INFO|2")) {
            level = INFO;
        } else if (levelString.toUpperCase().matches("EXEC|1")) {
            level = EXEC;
        } else if (levelString.toUpperCase().matches("WARN")) {
            level = WARN;
        } else if (levelString.toUpperCase().matches("ERROR|0")) {
            level = ERROR;
        } else if (levelString.toUpperCase().equals("FATAL")) {
            level = FATAL;
        }
        return level;
    }

    public String getCustomName() {
        return this.customName;
    }

    public int getNum() {
        return this.num;
    }

    public boolean is(SepLogLevel minLevel) {
        return this.num >= minLevel.num;
    }
}

