/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.logging;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;

public class LogContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final InheritableThreadLocal<LogContext> logContext;
    private static transient String hostname;
    private static transient String hostIp;
    protected String userId;
    protected Date sessionCreationTimestamp;
    protected String sessionId;
    protected String userIp;

    public static LogContext getContext() {
        LogContext ctx = (LogContext)logContext.get();
        if (ctx == null) {
            ctx = new LogContext();
            logContext.set(ctx);
        }
        return ctx;
    }

    public static void updateContext(String sessionId, String name, String ip) {
        LogContext ctx = LogContext.getContext();
        ctx.sessionId = sessionId;
        ctx.userId = name;
        ctx.userIp = ip;
    }

    public static void destroy() {
        logContext.remove();
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getSessionCreationTimestamp() {
        return this.sessionCreationTimestamp;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public static String getHostname() {
        return hostname;
    }

    public static String getHostIp() {
        return hostIp;
    }

    protected void setUserId(String userId) {
        this.userId = userId;
    }

    protected void setSessionCreationTimestamp(Date sessionCreationTimestamp) {
        this.sessionCreationTimestamp = sessionCreationTimestamp;
    }

    protected void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    static {
        Enumeration<InetAddress> ias;
        logContext = new InheritableThreadLocal();
        Enumeration<NetworkInterface> nis = null;
        try {
            nis = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (nis != null && nis.hasMoreElements() && (ias = nis.nextElement().getInetAddresses()).hasMoreElements()) {
            InetAddress ia = ias.nextElement();
            hostIp = ia.getHostAddress();
            hostname = ia.getCanonicalHostName();
        }
    }
}

