/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.AbstractMatcherFilter;
import ch.qos.logback.core.spi.FilterReply;
import de.sep.sesam.common.logging.HttpMethods;
import de.sep.sesam.common.logging.LogMessage;
import org.apache.commons.lang3.StringUtils;

public class GeneralRequestLogFilter
extends AbstractMatcherFilter<ILoggingEvent> {
    public static final LogMessage REQUEST_POST_LOG = new LogMessage(){

        @Override
        public String message() {
            return "POST {0}\n{1}\n==== END REQUEST ====";
        }

        @Override
        public String key() {
            return "request.post";
        }
    };
    public static final LogMessage REQUEST_GET_LOG = new LogMessage(){

        @Override
        public String message() {
            return "GET {0}";
        }

        @Override
        public String key() {
            return "request.get";
        }
    };

    @Override
    public FilterReply decide(ILoggingEvent event) {
        if (this.isStarted()) {
            if (event.getLevel() != Level.DEBUG && event.getLevel() != Level.TRACE) {
                return this.onMismatch;
            }
            String method = event.getMDCPropertyMap().get("method");
            String key = event.getMDCPropertyMap().get("logkey");
            if (this.isMethodAcceptable(method) || StringUtils.startsWith(key, "request.")) {
                return this.onMatch;
            }
            return this.onMismatch;
        }
        return this.onMismatch;
    }

    private boolean isMethodAcceptable(String methodName) {
        for (HttpMethods httpMethod : HttpMethods.values()) {
            if (!StringUtils.equalsIgnoreCase(httpMethod.getMethod(), methodName)) continue;
            return true;
        }
        return false;
    }
}

