/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ExceptionLogFilter
extends Filter<ILoggingEvent> {
    private String exception;
    private String pattern;

    @Override
    public FilterReply decide(ILoggingEvent event) {
        if (this.isStarted()) {
            if (this.exception != null) {
                String exception = event.getMDCPropertyMap().get("exception");
                if (this.exception.equals(exception)) {
                    return FilterReply.DENY;
                }
            } else if (this.pattern != null) {
                Pattern p;
                Matcher m;
                Pattern p2;
                Matcher m2;
                String s;
                String callpath = event.getMDCPropertyMap().get("callpath");
                String method = event.getMDCPropertyMap().get("method");
                if (callpath != null && method != null && (s = callpath + "#" + method).matches(this.pattern)) {
                    return FilterReply.DENY;
                }
                String message = event.getFormattedMessage();
                if (message != null && (m2 = (p2 = Pattern.compile(this.pattern, 40)).matcher(message)).matches()) {
                    return FilterReply.DENY;
                }
                StringBuilder sb = new StringBuilder();
                if (event.getLevel() != null) {
                    sb.append(event.getLevel().toString());
                    sb.append(" ");
                }
                if (StringUtils.isNotBlank(event.getLoggerName())) {
                    sb.append(event.getLoggerName());
                    sb.append(" ");
                }
                if (StringUtils.isNotBlank(event.getFormattedMessage())) {
                    sb.append(event.getFormattedMessage());
                    sb.append(" ");
                }
                if (StringUtils.isNotBlank(sb.toString()) && (m = (p = Pattern.compile(this.pattern, 40)).matcher(sb.toString())).matches()) {
                    return FilterReply.DENY;
                }
            }
        }
        return FilterReply.NEUTRAL;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public void start() {
        if (this.exception != null || this.pattern != null) {
            super.start();
        }
    }
}

