/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.logging;

import de.sep.sesam.common.json.JsonUtil;
import de.sep.sesam.common.logging.LogContext;
import de.sep.sesam.common.logging.LogGroup;
import de.sep.sesam.common.logging.LogMessage;
import de.sep.sesam.common.logging.SepLogLevel;
import de.sep.sesam.common.logging.messages.ErrorMessages;
import de.sep.sesam.common.logging.messages.MethodMessages;
import de.sep.sesam.common.logging.messages.SimpleMessage;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ContextLogger {
    public static final String CALLPATH = "callpath";
    public static final String EXCEPTION = "exception";
    public static final String GROUPING = "grouping";
    public static final String LEVEL = "level";
    public static final String METHOD = "method";
    public static final String MESSAGE_KEY = "logkey";
    public static final String MESSAGE_PARAM = "param";
    public static final String NAME = "name";
    public static final String SESSION_ID = "sid";
    public static final String USER_ID = "uid";
    public static final String USER_IP = "uip";
    private static final Pattern PW_PATTERN = Pattern.compile("\"?(password|passwd|spasswd|os_password|os_passwd|sesam_passwd|secret)\"?[:=\\s]+\"?([^\"*\\u2022\\s,]+)\"?");
    private static final Pattern LOG_PARAM_PATTERN = Pattern.compile("\\{[0-9]+}");
    private final HashMap<String, Long> timingMap = new HashMap();
    private final Logger internalLogger;
    private String callpath;
    private static final NumberFormat formatter = NumberFormat.getNumberInstance();

    public ContextLogger(Class<?> clazz) {
        assert (clazz != null);
        this.internalLogger = LoggerFactory.getLogger(clazz);
    }

    public ContextLogger(String name) {
        assert (StringUtils.isNotBlank(name));
        this.internalLogger = LoggerFactory.getLogger(name);
    }

    public String maskPassword(Object text) {
        Object t;
        Object object = t = text != null ? text.toString() : null;
        if (StringUtils.isNotBlank((CharSequence)t)) {
            Matcher matcher = PW_PATTERN.matcher((CharSequence)t);
            while (matcher.find()) {
                t = ((String)t).substring(0, matcher.start(2)) + StringUtils.repeat('*', 5) + ((String)t).substring(matcher.end(2));
                matcher = PW_PATTERN.matcher((CharSequence)t);
            }
        }
        return t;
    }

    private String computeCallpath(String name) {
        if (StringUtils.isBlank(name)) {
            return name;
        }
        return StringUtils.removeStart(name, "de.sep.sesam.").replaceAll("\\B\\w+(\\.[a-z])", "$1");
    }

    public void log(SepLogLevel level, String method, LogGroup grouping, LogMessage message, Throwable exception, Object ... params) {
        Matcher matcher;
        List<Object> parameter;
        String me;
        if (!this.isEnabled(level) && grouping != LogGroup.SECURITY) {
            return;
        }
        assert (this.internalLogger != null);
        LogContext ctx = LogContext.getContext();
        if (StringUtils.isBlank(this.callpath)) {
            String name = this.internalLogger.getName();
            if (!StringUtils.endsWith(name, "Mapper") && StringUtils.contains((CharSequence)name, "Mapper.")) {
                name = StringUtils.substringBeforeLast(name, ".");
            }
            this.callpath = this.computeCallpath(name);
        }
        if (StringUtils.isBlank(me = method)) {
            String name = this.internalLogger.getName();
            if (!StringUtils.endsWith(name, "Mapper") && StringUtils.contains((CharSequence)name, "Mapper.")) {
                name = StringUtils.substringAfterLast(name, ".");
            }
            me = name;
        }
        MDC.put(NAME, this.internalLogger.getName());
        MDC.put(METHOD, me);
        MDC.put(CALLPATH, this.callpath);
        MDC.put(LEVEL, level.toString());
        if (grouping == null) {
            MDC.remove(GROUPING);
        } else {
            MDC.put(GROUPING, grouping.toString());
        }
        MDC.put(MESSAGE_KEY, message.key());
        Throwable e = exception;
        List<Object> list = parameter = ArrayUtils.isNotEmpty(params) ? Arrays.asList(params) : null;
        if (CollectionUtils.isEmpty(parameter) && e != null) {
            String m = e.getMessage();
            while (StringUtils.isBlank(m) && e.getCause() != null) {
                e = e.getCause();
                assert (e != null);
                m = e.getMessage();
            }
            parameter = List.of(StringUtils.isNotBlank(m) ? m : "");
        }
        if (e != null) {
            MDC.put(EXCEPTION, e.getClass().getCanonicalName());
        }
        if (CollectionUtils.isNotEmpty(parameter)) {
            for (int i = 0; i < parameter.size(); ++i) {
                if (parameter.get(i) != null) {
                    Object o = parameter.get(i);
                    if (o instanceof Number || o instanceof String) {
                        MDC.put(MESSAGE_PARAM + i, o.toString());
                        continue;
                    }
                    MDC.put(MESSAGE_PARAM + i, JsonUtil.toString(o));
                    continue;
                }
                MDC.put(MESSAGE_PARAM + i, "null");
            }
        }
        if (ctx != null) {
            if (ctx.getSessionId() != null) {
                MDC.put(SESSION_ID, ctx.getSessionId());
            } else {
                MDC.remove(SESSION_ID);
            }
            if (ctx.getUserId() != null) {
                MDC.put(USER_ID, ctx.getUserId());
            } else {
                MDC.remove(USER_ID);
            }
            if (ctx.getUserIp() != null) {
                MDC.put(USER_IP, ctx.getUserIp());
            } else {
                MDC.remove(USER_IP);
            }
        } else {
            MDC.remove(SESSION_ID);
            MDC.remove(USER_ID);
            MDC.remove(USER_IP);
        }
        String logMessage = null;
        Object[] paramsCopy = null;
        if (CollectionUtils.isNotEmpty(parameter)) {
            paramsCopy = new Object[parameter.size()];
            for (int i = 0; i < parameter.size(); ++i) {
                paramsCopy[i] = parameter.get(i) != null && parameter.get(i).getClass().isArray() ? ArrayUtils.toString(parameter.get(i)) : (parameter.get(i) instanceof Number ? formatter.format(parameter.get(i)) : parameter.get(i));
            }
        }
        if (paramsCopy != null && StringUtils.isNotBlank(message.message()) && (matcher = LOG_PARAM_PATTERN.matcher(message.message())).find()) {
            try {
                logMessage = MessageFormat.format(message.message(), paramsCopy);
            }
            catch (NumberFormatException ex) {
                logMessage = message.message();
            }
        }
        if (logMessage == null) {
            logMessage = message.message();
        }
        switch (level) {
            case TRACE: {
                this.internalLogger.trace(logMessage, e);
                break;
            }
            case DEBUG: {
                this.internalLogger.debug(logMessage, e);
                break;
            }
            case INFO: {
                this.internalLogger.info(logMessage, e);
                break;
            }
            case WARN: {
                this.internalLogger.warn(logMessage, e);
                break;
            }
            case ERROR: {
                this.internalLogger.error(logMessage, e);
                break;
            }
            case FATAL: {
                this.internalLogger.error(logMessage, e);
                break;
            }
        }
        MDC.clear();
    }

    public void trace(String method, String msg, Object ... param) {
        this.trace(method, LogGroup.TRACE, new SimpleMessage(msg), param);
    }

    public void trace(String method, LogGroup grouping, LogMessage message, Object ... params) {
        this.log(SepLogLevel.TRACE, method, grouping, message, null, params);
    }

    public void debug(String method, LogGroup grouping, LogMessage message, Object ... params) {
        this.log(SepLogLevel.DEBUG, method, grouping, message, null, params);
    }

    public void debug(String method, LogMessage message, Object ... params) {
        this.log(SepLogLevel.DEBUG, method, LogGroup.DEBUG, message, null, params);
    }

    public void debug(String method, String message, Object ... params) {
        this.log(SepLogLevel.DEBUG, method, LogGroup.DEBUG, new SimpleMessage(message), null, params);
    }

    public void debug(String method, LogGroup group, String msg, Object ... param) {
        this.debug(method, group, new SimpleMessage(msg), param);
    }

    public void info(String method, LogGroup grouping, LogMessage message, Object ... params) {
        this.log(SepLogLevel.INFO, method, grouping, message, null, params);
    }

    public void start(String method, Object ... params) {
        this.start(method, SepLogLevel.DEBUG, LogGroup.START, params);
    }

    public void start(String method, SepLogLevel level, LogGroup group, Object ... params) {
        this.timingMap.put(method, System.currentTimeMillis());
        this.log(level, method, group, MethodMessages.START, null, this.makeMessage(params));
    }

    private String makeMessage(Object ... params) {
        ArrayList<Object> paramsFiltered = null;
        if (ArrayUtils.isNotEmpty(params)) {
            paramsFiltered = new ArrayList<Object>();
            for (Object param : params) {
                if (param != null && ("ISepHttpRequest".equals(param.getClass().getSimpleName()) || "SepHttpRequest".equals(param.getClass().getSimpleName()))) continue;
                paramsFiltered.add(param);
            }
        }
        Object[] newParams = null;
        if (paramsFiltered != null && !paramsFiltered.isEmpty()) {
            newParams = paramsFiltered.toArray(new Object[0]);
        }
        Object message = "";
        if (newParams != null && newParams.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(" [");
            for (Object newParam : newParams) {
                String s;
                String string = newParam == null ? "null" : (s = StringUtils.startsWith(newParam.getClass().getName(), "de.sep.sesam.model.") ? JsonUtil.toString(newParam) : newParam.toString());
                if (!StringUtils.isNotBlank(s)) continue;
                sb.append(this.maskPassword(s));
                sb.append(", ");
            }
            message = StringUtils.removeEnd(sb.toString(), ", ") + "]";
        }
        return message;
    }

    public void success(String method, Object ... params) {
        this.success(method, SepLogLevel.DEBUG, LogGroup.SUCCESS, params);
    }

    public void success(String method, SepLogLevel level, LogGroup group, Object ... params) {
        Long startTime = this.timingMap.get(method);
        if (startTime == null) {
            this.log(level, method, group, MethodMessages.SUCCESS, null, this.makeMessage(params));
        } else {
            this.log(level, method, group, MethodMessages.SUCCESS_TIMING, null, System.currentTimeMillis() - startTime, this.makeMessage(params));
        }
    }

    public void info(String method, String message, Object ... params) {
        this.log(SepLogLevel.INFO, method, LogGroup.INFO, new SimpleMessage(message), null, params);
    }

    public void info(String method, LogMessage message, Object ... params) {
        this.log(SepLogLevel.INFO, method, LogGroup.INFO, message, null, params);
    }

    public void info(String method, LogGroup grouping, LogGroup grouping2, LogMessage message, Object ... params) {
        this.log(SepLogLevel.INFO, method, grouping, message, null, params);
        this.log(SepLogLevel.INFO, method, grouping2, message, null, params);
    }

    public void warn(String method, String message, Object ... params) {
        this.log(SepLogLevel.WARN, method, LogGroup.WARN, new SimpleMessage(message), null, params);
    }

    public void warn(String method, LogGroup grouping, LogMessage message, Object ... params) {
        this.log(SepLogLevel.WARN, method, grouping, message, null, params);
    }

    public void warn(String method, LogGroup grouping, LogGroup grouping2, LogMessage message, Object ... params) {
        this.log(SepLogLevel.WARN, method, grouping, message, null, params);
        this.log(SepLogLevel.WARN, method, grouping2, message, null, params);
    }

    public void warn(String method, LogGroup group, String msg, Object ... param) {
        this.warn(method, group, new SimpleMessage(msg), param);
    }

    public void warn(String method, Throwable ex, Object ... param) {
        this.log(SepLogLevel.WARN, method, LogGroup.ERROR, ErrorMessages.EXCEPTION, ex, param);
    }

    public void error(String method, String message, Object ... params) {
        this.log(SepLogLevel.ERROR, method, LogGroup.ERROR, new SimpleMessage(message), null, params);
    }

    public void error(String method, LogGroup grouping, LogMessage message, Object ... params) {
        this.log(SepLogLevel.ERROR, method, grouping, message, null, params);
    }

    public void error(String method, LogGroup grouping, LogMessage message, Throwable e, Object ... params) {
        this.log(SepLogLevel.ERROR, method, grouping, message, e, params);
    }

    public void error(String method, Throwable e, Object ... params) {
        this.log(SepLogLevel.ERROR, method, LogGroup.ABORT, ErrorMessages.EXCEPTION, e, params);
    }

    public void fatal(String method, LogMessage message, Object ... params) {
        this.log(SepLogLevel.FATAL, method, LogGroup.ABORT, message, null, params);
    }

    public void fatal(String method, Throwable e, Object ... params) {
        this.log(SepLogLevel.FATAL, method, LogGroup.ABORT, ErrorMessages.EXCEPTION, e, params);
    }

    public boolean isEnabled(SepLogLevel level) {
        return switch (level) {
            case SepLogLevel.TRACE -> this.internalLogger.isTraceEnabled();
            case SepLogLevel.DEBUG -> this.internalLogger.isDebugEnabled();
            case SepLogLevel.FATAL, SepLogLevel.EXEC -> true;
            case SepLogLevel.INFO -> this.internalLogger.isInfoEnabled();
            case SepLogLevel.WARN -> this.internalLogger.isWarnEnabled();
            case SepLogLevel.ERROR -> this.internalLogger.isErrorEnabled();
            default -> false;
        };
    }

    public void status(String method, String msg, Object ... param) {
        this.info(method, new SimpleMessage(msg), param);
    }

    public void transfer(String method, Object ... param) {
        this.info(method, LogGroup.TRANSFER, MethodMessages.CALL, param);
    }

    @Generated
    protected Logger getInternalLogger() {
        return this.internalLogger;
    }

    static {
        formatter.setGroupingUsed(false);
    }
}

