/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NoPwdSerializer {
    private static final JsonFactory factory = new JsonFactory();
    private static final char[] SPACES = new char[1024];

    public static void serialize(JsonNode cur, OutputStream out) throws IOException {
        JsonGenerator gen = factory.createGenerator(out);
        NoPwdSerializer.serialize(cur, gen, 0);
        gen.flush();
    }

    private static void serialize(JsonNode cur, JsonGenerator gen, int level) throws IOException {
        if (cur == null) {
            return;
        }
        if (cur.isNull()) {
            gen.writeNull();
        } else if (cur.isArray()) {
            gen.writeStartArray();
            Iterator<JsonNode> it = cur.iterator();
            while (it.hasNext()) {
                NoPwdSerializer.serialize(it.next(), gen, level + 1);
            }
            gen.writeEndArray();
        } else if (cur.isObject()) {
            gen.writeStartObject();
            Iterator<Map.Entry<String, JsonNode>> it = cur.fields();
            while (it.hasNext()) {
                Map.Entry<String, JsonNode> node = it.next();
                gen.writeFieldName(node.getKey());
                if (StringUtils.endsWith(node.getKey(), "assword") || StringUtils.endsWith(node.getKey(), "asswd") || StringUtils.equalsIgnoreCase(node.getKey(), "secret")) {
                    gen.writeString(StringUtils.repeat('\u2022', 5));
                    continue;
                }
                NoPwdSerializer.serialize(node.getValue(), gen, level + 1);
            }
            gen.writeEndObject();
        } else if (cur.isBoolean()) {
            gen.writeBoolean(cur.asBoolean());
        } else if (cur.isInt()) {
            gen.writeNumber(cur.intValue());
        } else if (cur.isDouble()) {
            gen.writeNumber(cur.doubleValue());
        } else if (cur.isShort()) {
            gen.writeNumber(cur.shortValue());
        } else if (cur.isLong()) {
            gen.writeNumber(cur.longValue());
        } else if (cur.isFloat()) {
            gen.writeNumber(cur.floatValue());
        } else {
            gen.writeString(cur.textValue());
        }
    }

    static {
        for (int i = 0; i < SPACES.length; ++i) {
            NoPwdSerializer.SPACES[i] = 32;
        }
    }
}

