/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.sep.sesam.common.json.HumanDateDeserializer;
import de.sep.sesam.common.json.NoPwdSerializer;
import de.sep.sesam.common.util.Joiner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;

public class JsonUtil {
    private static final ObjectMapper mapper = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.USE_LONG_FOR_INTS, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).setDefaultPropertyInclusion(JsonInclude.Include.NON_EMPTY);

    public static <T> T read(Reader in, Class<T> type) throws IOException {
        return mapper.readValue(in, type);
    }

    public static String tryPrettyPrint(String original) {
        try {
            JsonNode tree = mapper.readTree(original);
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(tree);
        }
        catch (Exception e) {
            return original;
        }
    }

    public static <T> T read(String value, Class<T> type) throws IOException {
        return JsonUtil.read(new StringReader(value), type);
    }

    public static <T> List<T> readList(String value, Class<T> type) throws IOException {
        return (List)mapper.readValue(value, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, type));
    }

    public static void write(Object entries, PrintWriter out, String dateformat) throws IOException {
        StringWriter w = new StringWriter();
        if (dateformat == null) {
            mapper.writeValue(w, entries);
        } else {
            ObjectWriter wr = mapper.writer().with(new SimpleDateFormat(dateformat));
            wr.writeValue(w, entries);
        }
        out.print(w);
    }

    public static void write(List<?> entries, PrintWriter out) throws IOException {
        if (entries == null) {
            out.println("{}");
            return;
        }
        out.println("[");
        int i = entries.size();
        for (Object entry : entries) {
            StringWriter w = new StringWriter();
            mapper.writeValue(w, entry);
            out.print(w);
            if (--i == 0) continue;
            out.println(',');
        }
        out.println("\n]\n");
    }

    public static void write(Iterable<?> entries, PrintWriter out) throws IOException {
        if (entries == null) {
            out.println("{}");
            return;
        }
        out.println("[");
        for (Object entry : entries) {
            StringWriter w = new StringWriter();
            mapper.writeValue(w, entry);
            out.print(w);
            out.println(',');
        }
        out.println("null\n]\n}\n");
    }

    public static String writeString(Object entry) throws IOException {
        StringWriter w = new StringWriter();
        mapper.writeValue(w, entry);
        return w.toString();
    }

    public static String getString(Object value) throws IOException {
        return JsonUtil.getString(value, false, null);
    }

    public static String toString(Object value) {
        try {
            return JsonUtil.getString(value, false, null);
        }
        catch (IOException e) {
            return "{\"ERROR\":\"" + e.getMessage() + "\"";
        }
    }

    public static String getString(Object value, boolean pretty, String dateformat) throws IOException {
        StringWriter wr = new StringWriter();
        if (!pretty) {
            JsonUtil.write(value, new PrintWriter(wr), dateformat);
        } else {
            ObjectWriter owr = mapper.writerWithDefaultPrettyPrinter();
            if (dateformat != null) {
                owr = owr.with(new SimpleDateFormat(dateformat));
            }
            owr.writeValue(wr, value);
        }
        return wr.toString();
    }

    public static <T> T read(JsonNode jsonNode, Class<T> clazz) throws IOException {
        return mapper.treeToValue((TreeNode)jsonNode, clazz);
    }

    public static JsonNode read(byte[] body) throws IOException {
        return mapper.readTree(body);
    }

    public static JsonNode read(String body) throws IOException {
        return mapper.readTree(body);
    }

    public static <T> T cloneModel(T original) {
        if (original == null) {
            return null;
        }
        try {
            return (T)JsonUtil.read(JsonUtil.getString(original), original.getClass());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String prettyLog(JsonNode json) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            NoPwdSerializer.serialize(json, out);
            return out.toString(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public static String convertResultSetToJson(ResultSet resultSet) throws SQLException {
        assert (resultSet != null);
        Joiner commaJoiner = Joiner.on(", ");
        Joiner commaJoinerNL = Joiner.on(", \n");
        StringBuilder builder = new StringBuilder();
        builder.append("[\n");
        ArrayList<CallSite> results = new ArrayList<CallSite>();
        while (resultSet.next()) {
            ArrayList<String> resultBits = new ArrayList<String>();
            ResultSetMetaData metaData = resultSet.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                StringBuilder resultBit = new StringBuilder();
                String columnName = metaData.getColumnName(i);
                resultBit.append("\"").append(columnName).append("\": ");
                if (-5 == metaData.getColumnType(i) || 4 == metaData.getColumnType(i) || 3 == metaData.getColumnType(i) || 6 == metaData.getColumnType(i) || 8 == metaData.getColumnType(i) || 2 == metaData.getColumnType(i)) {
                    resultBit.append(resultSet.getString(i));
                } else {
                    String res = resultSet.getString(i);
                    if (res == null) {
                        resultBit.append("null");
                    } else {
                        resultBit.append("\"").append(StringEscapeUtils.escapeJson(res)).append("\"");
                    }
                }
                resultBits.add(resultBit.toString());
            }
            results.add((CallSite)((Object)("    { " + commaJoiner.join(resultBits) + " } ")));
        }
        builder.append(commaJoinerNL.join(results));
        builder.append("\n]");
        return builder.toString();
    }

    public static JsonNode readTree(String content) throws JsonProcessingException {
        return mapper.readTree(content);
    }

    public static JsonNode createNodeFromList(List<JsonNode> nodes) {
        return mapper.createArrayNode().addAll(nodes);
    }

    static {
        mapper.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        SimpleModule dateModule = new SimpleModule("HumanDate");
        dateModule.addDeserializer(Date.class, new HumanDateDeserializer());
        mapper.registerModule(dateModule);
        mapper.setAnnotationIntrospector(new JacksonAnnotationIntrospector());
    }
}

