/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import org.apache.commons.lang3.StringUtils;

public class WindowsRegistry {
    public static final String readRegistry(String location, String key) {
        assert (location != null && key != null);
        try {
            Process process = Runtime.getRuntime().exec("reg query \"" + location + "\" /v " + key);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String output = reader.getResult();
            output = output.trim();
            if (StringUtils.isBlank(output)) {
                return null;
            }
            if (!output.contains("\r\n")) {
                return null;
            }
            String[] l = StringUtils.split(output, "\r\n");
            if (l != null && l.length > 1 && l[1] != null) {
                output = l[1].trim();
            }
            if (!(output = output.replace("    ", "\t")).contains("\t")) {
                return null;
            }
            String[] parsed = output.split("\t");
            return parsed[parsed.length - 1];
        }
        catch (Exception e) {
            return null;
        }
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw = new StringWriter();

        public StreamReader(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getResult() {
            return this.sw.toString();
        }
    }
}

