/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.ini;

import de.sep.sesam.common.ini.IniUtils;
import de.sep.sesam.common.logging.ContextLogger;
import de.sep.sesam.common.logging.LogGroup;
import de.sep.sesam.common.runtime.JavaPropertyUtils;
import de.sep.sesam.common.text.I18n;
import de.sep.sesam.common.util.HostUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SesamIni {
    private static Hashtable<String, String> iniHashtable = new Hashtable();
    private static SesamIni instance;
    private final ContextLogger log = new ContextLogger(this.getClass());
    private final String PATHS = "[PATHES]";
    private final String SERVER = "[SERVER]";
    private final String SETUP = "[SETUP]";
    private String smIniFilename;
    private String smGuiWorkdirpath;
    private URL smIniURL;
    private int internalError = 0;

    private SesamIni() {
    }

    public static synchronized SesamIni getInstance() {
        if (instance == null) {
            instance = new SesamIni();
            instance.init();
        }
        return instance;
    }

    public static void setInstance(Hashtable<String, String> values) {
        assert (values != null);
        instance = new SesamIni();
        iniHashtable = values;
        String javaVersion = System.getProperty("java.version");
        String javaRuntime = JavaPropertyUtils.getRuntime();
        String javaVm = JavaPropertyUtils.getVm();
        String os = JavaPropertyUtils.getOs();
        iniHashtable.put("[SERVER]java_version", javaVersion);
        iniHashtable.put("[SERVER]java_runtime", javaRuntime);
        iniHashtable.put("[SERVER]java_vm", javaVm);
        iniHashtable.put("[SERVER]os", os);
    }

    public void reload() {
        assert (iniHashtable != null);
        iniHashtable.clear();
        this.init();
    }

    private void init() {
        File f;
        String method = "init";
        String sEncoding = null;
        String hashtableKey = "";
        this.log.debug("init", "RemoteIni.init: started.", new Object[0]);
        String javaVersion = System.getProperty("java.version");
        String javaRuntime = JavaPropertyUtils.getRuntime();
        String javaVm = JavaPropertyUtils.getVm();
        String os = JavaPropertyUtils.getOs();
        iniHashtable.put("[SERVER]java_version", javaVersion);
        iniHashtable.put("[SERVER]java_runtime", javaRuntime);
        iniHashtable.put("[SERVER]java_vm", javaVm);
        iniHashtable.put("[SERVER]os", os);
        this.log.debug("init", "java_version " + javaVersion, new Object[0]);
        this.log.debug("init", "java_runtime " + javaRuntime, new Object[0]);
        this.log.debug("init", "java_vm " + javaVm, new Object[0]);
        this.log.debug("init", "os " + os, new Object[0]);
        String string = this.smIniFilename = IniUtils.findIniPath() != null ? IniUtils.findIniPath().getAbsolutePath() : null;
        if (this.smIniFilename == null) {
            this.setInternalError(-1);
        }
        this.log.debug("init", "smIniFile is " + this.smIniFilename, new Object[0]);
        if (this.getInternalError() == 0) {
            StringBuilder smIniBuf = new StringBuilder();
            smIniBuf.append("file:///");
            smIniBuf.append(this.smIniFilename);
            try {
                this.smIniURL = new URL(smIniBuf.toString());
            }
            catch (MalformedURLException e) {
                this.setInternalError(-3);
            }
        }
        if (this.getInternalError() == 0 && !(f = new File(this.smIniFilename)).exists()) {
            this.setInternalError(-31);
        }
        if (this.getInternalError() == 0) {
            this.smGuiWorkdirpath = this.getEntry(this.smIniURL, "[PATHES]", "gv_rw_work");
            if (this.smGuiWorkdirpath == null) {
                this.setInternalError(-42);
            } else {
                this.smGuiWorkdirpath = this.smGuiWorkdirpath.trim();
                StringBuilder sb = new StringBuilder();
                sb.append(this.smGuiWorkdirpath);
                if (!this.smGuiWorkdirpath.endsWith(System.getProperty("file.separator"))) {
                    sb.append(System.getProperty("file.separator"));
                }
                iniHashtable.put("[PATHES]workDirPath", sb.toString());
                this.log.debug("init", "Current working directory: " + sb, new Object[0]);
            }
        }
        if (this.getInternalError() == 0) {
            this.fillHashtable(this.smIniURL);
        }
        if (this.getInternalError() == 0) {
            sEncoding = this.getEntry(this.smIniURL, "[SETUP]", "encoding");
            if (sEncoding == null) {
                sEncoding = "ISO8859-1";
                this.log.warn("init", LogGroup.ERROR, "encoding not found in sm.ini [SETUP] so set encoding to: " + sEncoding, new Object[0]);
            } else if (sEncoding.equals("")) {
                sEncoding = "ISO8859-1";
                this.log.warn("init", LogGroup.ERROR, "encoding without value found in sm.ini [SETUP] so set encoding to: " + sEncoding, new Object[0]);
            }
            sEncoding = sEncoding.trim();
            hashtableKey = "[setup]encoding";
            iniHashtable.put(hashtableKey, sEncoding);
        }
        this.log.debug("init", "RemoteIni.init finished.", new Object[0]);
    }

    private String getEntry(URL url, String searchItem, String searchString) {
        InputStream conn = null;
        BufferedReader in = null;
        String lineString = null;
        String currentItem = "";
        String currentKey = null;
        String currentEntry = null;
        int equalPos = 0;
        try {
            conn = url.openStream();
            in = new BufferedReader(new InputStreamReader(conn));
            while ((lineString = in.readLine()) != null) {
                if (lineString.startsWith("#")) continue;
                if (lineString.startsWith("[")) {
                    currentItem = lineString.trim();
                }
                if ((equalPos = lineString.indexOf("=")) <= 0) continue;
                currentKey = lineString.substring(0, equalPos).trim();
                if (!currentItem.equalsIgnoreCase(searchItem) || !currentKey.startsWith(searchString)) continue;
                currentEntry = lineString.substring(equalPos + 1);
            }
            in.close();
            conn.close();
        }
        catch (IOException e) {
            System.err.println("IOException='" + e + "'");
        }
        return currentEntry;
    }

    private void fillHashtable(URL url) {
        int equalPos = 0;
        String lineString = "";
        String item = "";
        Object hashtableKey = "";
        String hashtableEntry = "";
        InputStream conn = null;
        BufferedReader in = null;
        try {
            conn = url.openStream();
            in = new BufferedReader(new InputStreamReader(conn));
            while ((lineString = in.readLine()) != null) {
                if (lineString.startsWith("#")) continue;
                if (lineString.startsWith("[")) {
                    item = lineString;
                }
                if ((equalPos = lineString.indexOf("=")) <= 0) continue;
                hashtableKey = lineString.substring(0, equalPos).trim();
                hashtableEntry = lineString.substring(equalPos + 1);
                hashtableEntry = hashtableEntry.trim();
                hashtableKey = item + (String)hashtableKey;
                iniHashtable.put((String)hashtableKey, hashtableEntry);
            }
            in.close();
        }
        catch (IOException e) {
            instance.setInternalError(-6);
        }
    }

    public String get(String section, String config) {
        String returnVal = "";
        if (StringUtils.isBlank((CharSequence)section) || StringUtils.isBlank(config)) {
            return returnVal;
        }
        try {
            if (!StringUtils.startsWith((CharSequence)section, "[")) {
                section = "[" + (String)section + "]";
            }
            returnVal = iniHashtable.get((String)section + config);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnVal;
    }

    public void set(String key, String value) {
        assert (key != null);
        if (value != null) {
            iniHashtable.put(key, value);
        } else {
            iniHashtable.remove(key);
        }
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return iniHashtable.entrySet();
    }

    public int getInternalError() {
        return SesamIni.instance.internalError;
    }

    private void setInternalError(int err) {
        SesamIni.instance.internalError = err;
    }

    public String getErrorText() {
        Object errorText = "";
        errorText = SesamIni.instance.internalError == 0 ? I18n.get("RemoteIni.KonfigurationOk55", new Object[0]) : (SesamIni.instance.internalError == -1 ? (HostUtils.isWindowsHost() ? I18n.get("RemoteIni.Error.No_smini_in_windowsRegistry", new Object[0]) : I18n.get("RemoteIni.Error.Config_or_smini_notFound", "file:////etc/sesam2000.ini")) : (this.internalError == -3 ? I18n.get("RemoteIni.Error.ReadConfigFile", this.smIniFilename) : (this.internalError == -31 ? I18n.get("RemoteIni.Error.Config_file_notFound", this.smIniFilename) : (this.internalError == -4 ? I18n.get("RemoteIni.Error.ReadConfigFile", this.smIniFilename) + "\n" + I18n.get("RemoteIni.Error.Invalid_key_in_section", "gv_rw_ini", "[PATHES]") : (this.internalError == -41 ? I18n.get("RemoteIni.Error.ReadConfigFile", this.smIniFilename) + "\n" + I18n.get("RemoteIni.Error.Invalid_key_in_section", "sm_gui_inifile", "[SERVER]") : (this.internalError == -42 ? I18n.get("RemoteIni.Error.ReadConfigFile", this.smIniFilename) + "\n" + I18n.get("RemoteIni.Error.Invalid_key_in_section", "gv_rw_work", "[PATHES]") : I18n.get("RemoteIni.FehlerInDerKonfiguration80", new Object[0])))))));
        errorText = " \n" + (String)errorText + " \n\n" + I18n.get("RemoteIni.BitteU00FCberprU00FCfenSieDieEinstellungenOderN83", new Object[0]) + I18n.get("RemoteIni.WiederholenSieDieInstallationDerSesam-GUIN84", new Object[0]);
        return errorText;
    }

    public String isAvailable() {
        return "remote ini service is available.";
    }
}

