/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.ini;

import de.sep.sesam.common.io.WindowsRegistry;
import de.sep.sesam.common.util.HostUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;

public class IniUtils {
    public static final String defaultIniFilename = "file:////etc/sesam2000.ini";

    public static String getSMIni() {
        String smIniFilename = WindowsRegistry.readRegistry("HKLM\\SOFTWARE\\SEP Elektronik GmbH\\sesam", "sm_ini");
        if (smIniFilename == null) {
            smIniFilename = WindowsRegistry.readRegistry("HKLM\\software\\sep ag\\sesam", "sm_ini");
        }
        if (smIniFilename == null && (smIniFilename = System.getProperty("java.security.policy")) != null) {
            smIniFilename = smIniFilename.replaceAll("sm_java.policy", "sm.ini");
        }
        if (smIniFilename != null) {
            return smIniFilename.trim();
        }
        return null;
    }

    public static String getPolicyFilePath() {
        String path = System.getProperty("java.security.policy");
        if (Boolean.getBoolean("unitTestMode")) {
            String lookupPath = null;
            try {
                lookupPath = IniUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (StringUtils.isNotBlank(lookupPath)) {
                path = StringUtils.removeEnd(lookupPath, "/classes");
                Path p = new File(path).toPath().normalize();
                if (StringUtils.endsWith(p.getFileName().toString(), "-SNAPSHOT.jar")) {
                    path = p.getParent().toString();
                }
                path = path.concat("../test-classes/").concat("sm_java.policy");
            }
        }
        return path;
    }

    private static String resolveIniPathInUnitTestMode() {
        String lookupPath = null;
        try {
            lookupPath = IniUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        String iniPath = null;
        if (StringUtils.isNotBlank(lookupPath)) {
            iniPath = StringUtils.removeEnd(lookupPath, "/classes/");
            Path p = new File(iniPath).toPath().normalize();
            if (StringUtils.endsWith(p.getFileName().toString(), "-SNAPSHOT.jar")) {
                iniPath = p.getParent().toString();
            }
            iniPath = iniPath.concat("/test-classes/").concat(HostUtils.isWindowsHost() ? "sm.windows.ini" : "sm.unix.ini");
        }
        return iniPath;
    }

    public static File findIniPath() {
        String iniPath = null;
        if (Boolean.getBoolean("unitTestMode")) {
            iniPath = IniUtils.resolveIniPathInUnitTestMode();
        } else if (HostUtils.isWindowsHost()) {
            iniPath = IniUtils.getSMIni();
        } else {
            URL masterURL = null;
            try {
                masterURL = new URL(defaultIniFilename);
            }
            catch (MalformedURLException e) {
                return null;
            }
            String smIniFilename = IniUtils.getEntry(masterURL, "", "SM_INI");
            if (StringUtils.isNotBlank(smIniFilename)) {
                iniPath = smIniFilename.trim();
            }
        }
        return StringUtils.isNotBlank(iniPath) ? new File(iniPath) : null;
    }

    private static String getEntry(URL url, String searchItem, String searchString) {
        InputStream conn = null;
        BufferedReader in = null;
        String lineString = null;
        String currentItem = "";
        String currentKey = null;
        String currentEntry = null;
        int equalPos = 0;
        try {
            conn = url.openStream();
            in = new BufferedReader(new InputStreamReader(conn));
            while ((lineString = in.readLine()) != null) {
                if (lineString.startsWith("#")) continue;
                if (lineString.startsWith("[")) {
                    currentItem = lineString.trim();
                }
                if ((equalPos = lineString.indexOf("=")) <= 0) continue;
                currentKey = lineString.substring(0, equalPos).trim();
                if (!currentItem.equalsIgnoreCase(searchItem) || !currentKey.startsWith(searchString)) continue;
                currentEntry = lineString.substring(equalPos + 1);
            }
            in.close();
            conn.close();
        }
        catch (IOException e) {
            System.err.println("IOException='" + e + "'");
        }
        return currentEntry;
    }
}

