/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class HumanDate {
    private static final DateTimeFormatter defaultDateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter defaultTimeFormat = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter[] dateFormats = new DateTimeFormatter[]{defaultDateFormat, DateTimeFormatter.ofPattern(DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.FULL, FormatStyle.FULL, IsoChronology.INSTANCE, Locale.GERMAN)), DateTimeFormatter.ofPattern(DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.FULL, FormatStyle.FULL, IsoChronology.INSTANCE, Locale.ENGLISH)), DateTimeFormatter.ofPattern(DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.SHORT, FormatStyle.SHORT, IsoChronology.INSTANCE, Locale.GERMAN)), DateTimeFormatter.ofPattern(DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.SHORT, FormatStyle.SHORT, IsoChronology.INSTANCE, Locale.ENGLISH)), DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.RFC_1123_DATE_TIME, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss 0").withLocale(Locale.ENGLISH), DateTimeFormatter.ofPattern("MMM d, yyyy h:m:s a").withLocale(Locale.ENGLISH), DateTimeFormatter.ofPattern("MMM d, yyyy h:m:s").withLocale(Locale.ENGLISH), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm E").withLocale(Locale.ENGLISH), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm E").withLocale(Locale.GERMAN), DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss"), DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm"), DateTimeFormatter.ofPattern("dd.MM.yy HH:mm:ss"), DateTimeFormatter.ofPattern("d.M.y HH:mm:ss"), DateTimeFormatter.ofPattern("MM/dd/yy HH:mm:ss"), DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss"), DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"), DateTimeFormatter.ofPattern("d.M.y HH:mm"), DateTimeFormatter.ofPattern("dd.MM.yy HH:mm"), DateTimeFormatter.ofPattern("MM/dd/yy HH:mm"), DateTimeFormatter.ofPattern("MM/dd/yyyy H:mm"), DateTimeFormatter.ofPattern("yyyy/MM/dd H:m"), DateTimeFormatter.ofPattern("yyyy-MM-dd H:m"), DateTimeFormatter.ofPattern("d.M.y H:mm"), DateTimeFormatter.ofPattern("dd.MM.yy H:m"), DateTimeFormatter.ofPattern("MM/dd/yy H:m"), DateTimeFormatter.ofPattern("MM/dd/yyyy H:m"), DateTimeFormatter.ofPattern("yyyyMMddHHmmss"), DateTimeFormatter.ofPattern("dd.MM.yy"), DateTimeFormatter.ofPattern("dd.MM.yyyy"), DateTimeFormatter.ofPattern("MM/dd/yy"), DateTimeFormatter.ofPattern("MM/dd/yyyy"), DateTimeFormatter.ofPattern("MMM d, yyyy").withLocale(Locale.ENGLISH), DateTimeFormatter.ofPattern("yyyy-MM-dd"), DateTimeFormatter.ofPattern("yy-MM-dd"), DateTimeFormatter.ofPattern("yyyy-MM-dd"), DateTimeFormatter.ofPattern("yyyyMMdd"), DateTimeFormatter.ofPattern("yyyyMMdd_HHmmssSSS"), DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"), DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS"), DateTimeFormatter.ofPattern(DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.MEDIUM, FormatStyle.MEDIUM, IsoChronology.INSTANCE, Locale.GERMAN)), DateTimeFormatter.ofPattern(DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.MEDIUM, FormatStyle.MEDIUM, IsoChronology.INSTANCE, Locale.ENGLISH)), DateTimeFormatter.ofPattern("HH:mm:ss"), defaultTimeFormat, DateTimeFormatter.ofPattern("yyyyMMddHHmm"), DateTimeFormatter.ofPattern("HHmm"), DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm:ss")};
    private static Date invalidDate;

    public static Date toDate(String date) {
        if (StringUtils.isBlank(date)) {
            return null;
        }
        Object s = HumanDate.trim(date);
        if (StringUtils.isBlank((CharSequence)s) || StringUtils.equalsAnyIgnoreCase((CharSequence)s, "null", "not_found", "never", "NULL:00", "-")) {
            return null;
        }
        Date d = HumanDate.toDate((String)s, defaultDateFormat);
        if (d != null) {
            return d;
        }
        if (((String)s).matches("[0-9]{2}:[0-9]{2}")) {
            d = HumanDate.toDate((String)s, defaultTimeFormat);
            if (d == null) {
                try {
                    SimpleDateFormat defaultDurationFormat = new SimpleDateFormat("HH:mm");
                    d = defaultDurationFormat.parse((String)s);
                }
                catch (ParseException defaultDurationFormat) {
                    // empty catch block
                }
            }
            if (d != null) {
                return d;
            }
        }
        if (((String)s).equalsIgnoreCase("today") || ((String)s).equalsIgnoreCase("now")) {
            return new Date();
        }
        if (((String)s).equalsIgnoreCase("tomorrow")) {
            return new Date(System.currentTimeMillis() + 86400000L);
        }
        if (((String)s).equalsIgnoreCase("next week")) {
            return new Date(System.currentTimeMillis() + 604800000L);
        }
        if (((String)s).equalsIgnoreCase("yesterday")) {
            return new Date(System.currentTimeMillis() - 86400000L);
        }
        if (((String)s).equalsIgnoreCase("last week")) {
            return new Date(System.currentTimeMillis() - 604800000L);
        }
        try {
            if (((String)s).indexOf(45) < 1 && ((String)s).indexOf(32) == -1 && ((String)s).indexOf(58) == -1) {
                if (((String)s).length() != 14 && ((String)s).length() != 8 || !((String)s).startsWith("20")) {
                    long ms = Long.parseLong((String)s);
                    return new Date(ms);
                }
                boolean isNumber = NumberUtils.isCreatable((String)s);
                if (isNumber && ((String)s).length() >= 14 && ((String)(s = ((String)s).substring(0, 14))).endsWith("99")) {
                    s = ((String)s).substring(0, 12) + "59";
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (((String)s).charAt(((String)s).length() - 1) != 'M' && ((String)s).lastIndexOf(32) == ((String)s).length() - 3) {
            s = ((String)s).substring(0, ((String)s).length() - 3);
        }
        for (DateTimeFormatter f : dateFormats) {
            d = HumanDate.toDate((String)s, f);
            if (d == null) continue;
            return d;
        }
        return null;
    }

    private static Date toDate(String s, DateTimeFormatter f) {
        assert (f != null);
        if (StringUtils.isBlank(s)) {
            return null;
        }
        Date d = null;
        try {
            TemporalAccessor ta = f.parse(s);
            if (ta != null) {
                LocalDateTime ldt = null;
                if (ta.isSupported(ChronoField.DAY_OF_MONTH) && ta.isSupported(ChronoField.HOUR_OF_DAY)) {
                    ldt = LocalDateTime.from(ta);
                } else if (ta.isSupported(ChronoField.DAY_OF_MONTH) && !ta.isSupported(ChronoField.HOUR_OF_DAY)) {
                    ldt = LocalDate.from(ta).atTime(0, 0);
                } else if (!ta.isSupported(ChronoField.DAY_OF_MONTH) && ta.isSupported(ChronoField.HOUR_OF_DAY)) {
                    ldt = LocalTime.from(ta).atDate(LocalDate.ofEpochDay(0L));
                }
                if (ldt != null) {
                    d = new Date(Instant.from(ldt.atZone(TimeZone.getDefault().toZoneId())).toEpochMilli());
                }
            }
        }
        catch (DateTimeException dateTimeException) {
            // empty catch block
        }
        return d;
    }

    public static Date[] toDate(String[] dates) {
        if (dates == null) {
            return null;
        }
        Date[] ret = new Date[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            ret[i] = HumanDate.toDate(dates[i]);
        }
        return ret;
    }

    private static String trim(String value) {
        int st;
        assert (value != null);
        int len = value.length();
        char[] val = value.toCharArray();
        for (st = 0; st < len && (val[st] <= ' ' || val[st] == '\"'); ++st) {
        }
        while (st < len && (val[len - 1] <= ' ' || val[st] == '\"')) {
            --len;
        }
        return st > 0 || len < value.length() ? value.substring(st, len) : value;
    }

    public static Date addHoursToDate(Date date, int hours) {
        assert (date != null);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.add(11, hours);
        return cal.getTime();
    }

    public static Date addMinutesToDate(Date date, long minutes) {
        if (date == null) {
            return date;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.add(11, (int)(minutes / 60L));
        cal.add(12, (int)(minutes % 60L));
        return cal.getTime();
    }

    public static Date getTime(Date date) {
        if (date == null) {
            return new Date(0L);
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.clear(5);
        cal.clear(7);
        cal.clear(8);
        cal.clear(6);
        cal.clear(4);
        cal.clear(3);
        cal.clear(2);
        cal.clear(1);
        return cal.getTime();
    }

    public static Date getDate(Date date) {
        if (date == null) {
            return new Date(0L);
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.clear(14);
        cal.clear(13);
        cal.clear(12);
        cal.clear(10);
        cal.clear(11);
        cal.clear(9);
        return cal.getTime();
    }

    public static long calculateMinutesDifference(Date date1, Date date2) {
        assert (date1 != null);
        assert (date2 != null);
        long millis1 = date1.getTime();
        long millis2 = date2.getTime();
        return (millis2 - millis1) / 60000L;
    }

    public static Date getDateTime(Date date, Date time) {
        if (date == null) {
            return date;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        if (time != null) {
            GregorianCalendar timecal = new GregorianCalendar();
            timecal.setTime(time);
            cal.set(10, timecal.get(10));
            cal.set(11, timecal.get(11));
            cal.set(9, timecal.get(9));
            cal.set(12, timecal.get(12));
            cal.set(13, timecal.get(13));
            cal.set(14, timecal.get(14));
        }
        return cal.getTime();
    }

    public static Date getEndOfDay(Date date) {
        assert (date != null);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getStartOfDay(Date date) {
        assert (date != null);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(9, 0);
        return cal.getTime();
    }

    public static Date[] getFullDayRange(Date day) {
        assert (day != null);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(day);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date[] result = new Date[2];
        result[0] = calendar.getTime();
        calendar.add(5, 1);
        result[1] = calendar.getTime();
        return result;
    }

    public static Date getInvalidDate() {
        if (invalidDate == null) {
            invalidDate = HumanDate.toDate("12/31/3000");
        }
        return invalidDate;
    }

    public static Long timeNoSecondsStrToMinutes(String s) {
        if (StringUtils.isEmpty(s) || !s.contains(":")) {
            return 0L;
        }
        String[] parts = s.split(":");
        long cur = (long)Integer.parseInt(parts[0]) * 60L;
        return cur += (long)Integer.parseInt(parts[1]);
    }

    public static Date getTimeByMinutes(Long duration) {
        assert (duration != null);
        GregorianCalendar calendar = new GregorianCalendar();
        int dd = (int)(duration / 1440L);
        int hh = (int)(duration / 60L) - 24 * dd;
        int mm = (int)(duration - (long)(hh * 60) - (long)(dd * 60 * 24));
        calendar.set(11, hh);
        calendar.set(12, mm);
        calendar.set(13, dd);
        return calendar.getTime();
    }

    public static Date getTimeByMinutesDayAsYear(Long duration) {
        GregorianCalendar calendar = new GregorianCalendar();
        int dd = (int)(duration / 1440L);
        int hh = (int)(duration / 60L) - 24 * dd;
        int mm = (int)(duration - (long)(hh * 60) - (long)(dd * 60 * 24));
        calendar.set(11, hh);
        calendar.set(12, mm);
        calendar.set(1, 2000 + dd);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static boolean compareHoursAndMinutes(Date dt1, Date dt2) {
        boolean bHour = false;
        boolean bMinutes = false;
        if (dt1 != null && dt2 != null) {
            GregorianCalendar gc1 = new GregorianCalendar();
            GregorianCalendar gc2 = new GregorianCalendar();
            gc1.setTime(dt1);
            gc2.setTime(dt2);
            bHour = gc1.get(11) == gc2.get(11);
            bMinutes = gc1.get(12) == gc2.get(12);
        }
        return bHour && bMinutes;
    }

    public static boolean compareDayAndYear(Date dt1, Date dt2) {
        boolean bDay = false;
        boolean bYear = false;
        if (dt1 != null && dt2 != null) {
            GregorianCalendar gc1 = new GregorianCalendar();
            GregorianCalendar gc2 = new GregorianCalendar();
            gc1.setTime(dt1);
            gc2.setTime(dt2);
            bDay = gc1.get(6) == gc2.get(6);
            bYear = gc1.get(1) == gc2.get(1);
        }
        return bDay && bYear;
    }
}

