/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.date;

import de.sep.sesam.common.date.DateFormats;
import de.sep.sesam.common.util.HostUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public final class DateUtils {
    private static final DateTimeFormatter dateOnlyNoSpaceFormat = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter dateOnlyWithDashFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter dateTimeUnderscoreFormat = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    private static final DateTimeFormatter dateTimeNoSpaceFormat = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter dateTimeSmShoFormat = DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm:ss");
    private static final DateTimeFormatter timeOnlyFormat = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final DateTimeFormatter timeOnlyNoSecondsFormat = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter weekDayOnlyFormat = DateTimeFormatter.ofPattern("EEE");
    private static final DateTimeFormatter uniqueIdDateTimeFormat = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    private static final DateTimeFormatter RFC1123DateTimeFormat = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withZone(ZoneOffset.UTC).withLocale(Locale.US);
    private static final Locale forcedDateLocale;
    private static final Comparator<Date> comparator;

    public static Comparator<Date> sorter() {
        return comparator;
    }

    public static String dateToDateStr(Date value) {
        return DateUtils.dateToDateStr(value, 2, null);
    }

    public static String dateToDateStr(Date value, Locale locale) {
        return DateUtils.dateToDateStr(value, 2, locale);
    }

    public static String dateToDateStr(Date value, int stylePattern) {
        return DateUtils.dateToDateStr(value, stylePattern, null);
    }

    public static String dateToDateStr(Date value, int stylePattern, Locale locale) {
        if (value == null) {
            return "";
        }
        if (locale == null) {
            locale = DateUtils.getDateLocale();
        }
        DateFormat df = DateFormat.getDateInstance(stylePattern, locale != null ? locale : Locale.getDefault());
        return df.format(value);
    }

    public static String dateToTimeStr(Date value) {
        return DateUtils.dateToTimeStr(value, 2, null);
    }

    public static String dateToTimeStr(Date value, Locale locale) {
        return DateUtils.dateToTimeStr(value, 2, locale);
    }

    public static String dateToTimeStr(Date value, int stylePattern) {
        return DateUtils.dateToTimeStr(value, stylePattern, null);
    }

    public static String dateToTimeStr(Date value, int stylePattern, Locale locale) {
        if (value == null) {
            return "";
        }
        if (locale == null) {
            locale = DateUtils.getDateLocale();
        }
        DateFormat df = DateFormat.getTimeInstance(stylePattern, locale != null ? locale : Locale.getDefault());
        return df.format(value);
    }

    public static String dateToDateTimeStr(Date value) {
        return DateUtils.dateToDateTimeStr(value, 2, null);
    }

    public static String dateToDateTimeStr(Date value, Locale locale) {
        return DateUtils.dateToDateTimeStr(value, 2, null);
    }

    public static String dateToDateTimeStr(Date value, int stylePattern) {
        return DateUtils.dateToDateTimeStr(value, stylePattern, null);
    }

    public static String dateToDateTimeStr(Date value, int stylePattern, Locale locale) {
        if (value == null) {
            return "";
        }
        if (locale == null) {
            locale = DateUtils.getDateLocale();
        }
        DateFormat df = DateFormat.getDateTimeInstance(stylePattern, stylePattern, locale != null ? locale : Locale.getDefault());
        return df.format(value);
    }

    public static String dateToDateOnlyNoSpaceStr(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtils.format(dateOnlyNoSpaceFormat, date.getTime());
    }

    public static String dateToDateOnlyStr(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtils.format(dateOnlyWithDashFormat, date.getTime());
    }

    public static String dateToTableFormatStr(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtils.format(dateTimeFormat, date.getTime());
    }

    public static String dateToFileNameStr(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtils.format(dateTimeUnderscoreFormat, date.getTime());
    }

    public static String dateToTimestampStr(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtils.format(dateTimeNoSpaceFormat, date.getTime());
    }

    public static String dateToSmShoStr(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtils.format(dateTimeSmShoFormat, date.getTime());
    }

    public static String dateToTimeFormat(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtils.format(timeOnlyFormat, date.getTime());
    }

    public static String dateToTimeNoSecondsStr(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtils.format(timeOnlyNoSecondsFormat, date.getTime());
    }

    public static String dateToWeekdayStr(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtils.format(weekDayOnlyFormat, date.getTime());
    }

    public static String dateToRFC1123Str(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtils.format(RFC1123DateTimeFormat, date.getTime());
    }

    public static Long getUniqueId() {
        String id = DateUtils.format(uniqueIdDateTimeFormat, System.currentTimeMillis());
        Long l = null;
        try {
            if (StringUtils.isNotBlank(id)) {
                l = Long.parseUnsignedLong(id);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l != null ? l : Long.valueOf(System.currentTimeMillis());
    }

    public static String minutesToTimeNoSecondsStr(Long minutes) {
        assert (minutes != null);
        long min = minutes % 60L;
        long hour = minutes / 60L;
        StringBuilder sb = new StringBuilder();
        sb.append(hour);
        sb.append(':');
        if (min < 10L) {
            sb.append('0');
        }
        sb.append(min);
        return sb.toString();
    }

    private static String format(DateTimeFormatter format, long millis) {
        assert (format != null);
        LocalDateTime ldt = LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), TimeZone.getDefault().toZoneId());
        return format.format(ldt);
    }

    public static Locale getDateLocale() {
        return forcedDateLocale;
    }

    public static Locale getLocaleForString(String localeString) {
        Locale locale = null;
        if (StringUtils.isNotBlank(localeString)) {
            String language = null;
            String country = null;
            String variant = null;
            StringTokenizer st = new StringTokenizer(localeString, "_");
            int tokensCount = st.countTokens();
            if (tokensCount > 0) {
                language = st.nextToken();
            }
            if (tokensCount > 1) {
                country = st.nextToken();
            }
            if (tokensCount > 2) {
                variant = st.nextToken();
            }
            if (language != null) {
                locale = new Locale(language.toUpperCase(), country != null ? country.toUpperCase() : "", variant != null ? variant : "");
            }
        }
        return locale;
    }

    public static DateFormat getDateFormat(String format) {
        assert (StringUtils.isNotBlank(format));
        Locale locale = DateUtils.getDateLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormat result = null;
        DateFormats df = DateFormats.valueOf(format.toUpperCase());
        switch (df) {
            case ISO: {
                result = new SimpleDateFormat("yyyy-MM-dd");
                break;
            }
            case ISOT: {
                result = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                break;
            }
            case ISOTIME: {
                result = new SimpleDateFormat("hh:mm:ss");
                break;
            }
            case ISOW: {
                result = new SimpleDateFormat("yyyy-MM-dd (EEE)");
                break;
            }
            case LD: {
                result = DateFormat.getDateInstance(2, locale);
                break;
            }
            case LDT: {
                result = DateFormat.getDateTimeInstance(2, 2, locale);
                break;
            }
            case LDW: {
                result = DateFormat.getDateInstance(2, locale);
                if (!(result instanceof SimpleDateFormat)) break;
                ((SimpleDateFormat)result).applyPattern(((SimpleDateFormat)result).toPattern() + " (EEE)");
                break;
            }
            case LT: {
                result = DateFormat.getTimeInstance(2, locale);
                break;
            }
        }
        return result;
    }

    public static boolean isSameDay(Calendar currentGregorianCalendar, Date date) {
        assert (currentGregorianCalendar != null);
        assert (date != null);
        Date current = currentGregorianCalendar.getTime();
        return org.apache.commons.lang3.time.DateUtils.isSameDay(current, date);
    }

    public static String normalize(String value) {
        if (StringUtils.isBlank(value)) {
            return value;
        }
        return StringUtils.trim(value).replaceAll("\u202f", " ").replaceAll("\\s+", " ");
    }

    static {
        comparator = new Comparator<Date>(){

            @Override
            public int compare(Date o1, Date o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        };
        String dateLocale = HostUtils.getenv("SESAM_DATE_LOCALE");
        if (StringUtils.isBlank(dateLocale)) {
            dateLocale = HostUtils.getProperty("sep.sesam.date.locale");
        }
        forcedDateLocale = DateUtils.getLocaleForString(dateLocale);
    }
}

