/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.common.brand;

import java.io.IOException;
import java.util.Properties;

public class SepVersion {
    private static final String propFileName = "META-INF/sesam_build_version.properties";
    private static final String build = "V5.2 Build 2 R ";
    private static String id;
    private static String gitId;
    private static String gitIdWebUi;
    private static String gitIdWebRestore;
    private static String gitBranch;
    private static String dateString;

    public static String getFullBuildString() {
        StringBuilder sb = new StringBuilder();
        sb.append(id);
        if (dateString != null) {
            sb.append(" ").append(dateString);
        }
        if (gitId != null) {
            sb.append(" ").append(gitId);
        }
        if (gitBranch != null) {
            sb.append(" (").append(gitBranch).append(")");
        }
        return sb.toString();
    }

    public static String getFullBuildStringWebUi() {
        StringBuilder sb = new StringBuilder();
        sb.append(build.trim());
        if (gitIdWebUi != null) {
            sb.append(" ").append(gitIdWebUi.trim(), 0, 7);
        }
        if (dateString != null) {
            sb.append(" ").append(dateString);
        }
        if (gitIdWebUi != null) {
            sb.append(" ").append(gitIdWebUi.trim());
        }
        if (gitBranch != null) {
            sb.append(" (").append(gitBranch).append(")");
        }
        return sb.toString();
    }

    public static String getFullBuildStringRestoreAssistant() {
        StringBuilder sb = new StringBuilder();
        sb.append(build.trim());
        if (gitIdWebRestore != null) {
            sb.append(" ").append(gitIdWebRestore.trim(), 0, 7);
        }
        if (dateString != null) {
            sb.append(" ").append(dateString);
        }
        if (gitIdWebRestore != null) {
            sb.append(" ").append(gitIdWebRestore.trim());
        }
        if (gitBranch != null) {
            sb.append(" (").append(gitBranch).append(")");
        }
        return sb.toString();
    }

    public static String getBuild() {
        return build;
    }

    public static String getId() {
        return id;
    }

    public static String getGitId() {
        return gitId;
    }

    public static String getGitBranch() {
        return gitBranch;
    }

    public static String getDateString() {
        return dateString;
    }

    public static String getVersion() {
        int idx = SepVersion.getId().indexOf(" ");
        return SepVersion.getId().substring(0, idx);
    }

    public static String getString() {
        return id + " " + dateString;
    }

    static {
        try {
            Properties versions = new Properties();
            versions.load(SepVersion.class.getClassLoader().getResourceAsStream(propFileName));
            String idString = versions.getProperty("git.commit.id.abbrev");
            gitId = versions.getProperty("git.commit.id");
            gitIdWebUi = versions.getProperty("git.commit.id.web-ui-ng2");
            gitIdWebRestore = versions.getProperty("git.commit.id.web-ui");
            gitBranch = versions.getProperty("git.branch");
            dateString = versions.getProperty("git.commit.time").replace('/', '-');
            id = build + idString;
        }
        catch (IOException e) {
            System.out.println("META-INF/sesam_build_version.properties not read: " + e.getMessage());
            id = "V5.2 Build 2 R  UNKNOWN";
        }
    }
}

