/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.cli.core.utils;

import de.sep.sesam.cli.core.params.BaseParams;
import de.sep.sesam.common.logging.LogMessage;
import de.sep.sesam.common.logging.SepLogLevel;
import de.sep.sesam.common.logging.messages.SimpleMessage;
import de.sep.sesam.model.cli.CliResultEntity;
import de.sep.sesam.model.cli.StatusMsgJsonEntity;
import de.sep.sesam.rest.exceptions.CliCommonErrorException;
import de.sep.sesam.rest.exceptions.ConnectionException;
import de.sep.sesam.rest.exceptions.ConnectionLostException;
import de.sep.sesam.rest.exceptions.IllegalParameterException;
import de.sep.sesam.rest.exceptions.ObjectInUseException;
import de.sep.sesam.rest.exceptions.ObjectNotFoundException;
import de.sep.sesam.rest.exceptions.OperationNotPossibleException;
import de.sep.sesam.rest.exceptions.ServiceException;
import de.sep.sesam.rest.json.JsonHttpRequest;
import de.sep.sesam.rest.json.JsonResult;
import de.sep.sesam.rest.utils.RestError;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class CliRequestExecutorClient {
    private boolean isJsonFormat;

    public void checkInfoService(String server, int port, JsonHttpRequest request, PrintStream out, PrintStream err) throws IOException {
        assert (server != null);
        assert (request != null);
        assert (out != null);
        assert (err != null);
        if (Boolean.getBoolean("unitTestMode")) {
            return;
        }
        int retry = 0;
        while (true) {
            block22: {
                try {
                    JsonResult result = request.call(server, port, "v2/server", "info", null, null);
                    if (result == null) break block22;
                    if (result.restError == null) {
                        return;
                    }
                    ServiceException e = result.restError.toServiceException();
                    if (OperationNotPossibleException.ONPMessage.STARTUP.equals(e.getLogMessage())) {
                        long startupDuration = -1L;
                        if (e.data != null && e.data.length == 1) {
                            try {
                                startupDuration = Long.decode(e.data[0].toString());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        e = new ConnectionLostException(null, ConnectionException.ConnectionMessage.UNABLE_TO_CONNECT, server, port, e.getLogMessage() != null && StringUtils.isNotBlank(e.getLogMessage().message()) ? "Cause: " + e.getLogMessage().message() + " " : "");
                        ((ConnectionLostException)e).setStartupDuration(startupDuration);
                    }
                    throw e;
                }
                catch (ConnectionLostException e) {
                    if (retry > 12) {
                        throw new IOException(e.getMessage());
                    }
                    ++retry;
                    if (e.getStartupDuration() > -1L) {
                        try {
                            long time = e.getStartupDuration();
                            long sleepTime = time < 10000L ? 10000L - time : 5000L;
                            Thread.sleep(sleepTime);
                        }
                        catch (Exception time) {}
                        continue;
                    }
                }
                catch (Exception e) {
                    if (retry > 12) {
                        String message = e.getMessage();
                        if (!(e instanceof ConnectException)) {
                            message = new ConnectionLostException(null, ConnectionException.ConnectionMessage.UNABLE_TO_CONNECT, server, port, StringUtils.isNotBlank(message) ? "Cause: " + message + " " : "").getMessage();
                        }
                        throw new IOException(message);
                    }
                    ++retry;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public List<String> readCommandFile(String path, PrintStream err, boolean isJson) throws IOException {
        File f = new File(path);
        if (!f.exists()) {
            this.printError(err, "Command file '" + f.getAbsolutePath() + "' not found.", isJson);
            return null;
        }
        if (!f.canRead()) {
            this.printError(err, "Command file '" + f.getAbsolutePath() + "' not readable.", isJson);
            return null;
        }
        if (f.length() == 0L) {
            this.printError(err, "Command file '" + f.getAbsolutePath() + "' empty.", isJson);
            return null;
        }
        List<String> lines = null;
        try (FileInputStream fin = new FileInputStream(f);){
            lines = IOUtils.readLines((InputStream)fin, Charset.defaultCharset());
        }
        return lines;
    }

    public JsonHttpRequest prepareRequestSecure(BaseParams baseParams) {
        assert (baseParams != null);
        if (StringUtils.isBlank(baseParams.getAuthorityPath())) {
            return this.prepareRequest(baseParams);
        }
        JsonHttpRequest request = new JsonHttpRequest(SepLogLevel.fromString(String.valueOf(baseParams.getVerbosity())), baseParams.getUser(), baseParams.getPassword(), baseParams.getConnectTimeout(), baseParams.getAuthorityPath());
        request.setKeepAlive(false);
        if (StringUtils.isNotBlank(baseParams.getCertificate())) {
            request.enableCertificateBasedAuthentication(new File(baseParams.getCertificate()));
        }
        request.setRedirectServers(baseParams.getRedirectServer() != null ? baseParams.getRedirectServer() : null);
        request.setMfaVerCode(baseParams.getTfaVerCode());
        request.setApiKey(baseParams.getApiKey());
        return request;
    }

    public JsonHttpRequest prepareRequest(BaseParams baseParams) {
        assert (baseParams != null);
        JsonHttpRequest request = this.prepareRequest(baseParams.getVerbosity(), baseParams.getConnectTimeout(), baseParams.getUser(), baseParams.getPassword(), baseParams.getCertificate());
        request.setRedirectServers(baseParams.getRedirectServer() != null ? baseParams.getRedirectServer() : null);
        request.setMfaVerCode(baseParams.getTfaVerCode());
        request.setApiKey(baseParams.getApiKey());
        return request;
    }

    public JsonHttpRequest prepareRequestWithoutRedirect(BaseParams baseParams) {
        return this.prepareRequest(baseParams.getVerbosity(), baseParams.getConnectTimeout(), baseParams.getUser(), baseParams.getPassword(), baseParams.getCertificate());
    }

    private JsonHttpRequest prepareRequest(int verbosity, int connectTimeout, String user, String password, String certificate) {
        JsonHttpRequest request = new JsonHttpRequest(SepLogLevel.fromString(String.valueOf(verbosity)), StringUtils.isNotBlank(user) ? user : null, StringUtils.isNotBlank(password) ? password : null, connectTimeout);
        request.setKeepAlive(false);
        if (StringUtils.isNotBlank(certificate)) {
            request.enableCertificateBasedAuthentication(new File(certificate));
        }
        return request;
    }

    public void printError(PrintStream err, String msg, boolean isJson) {
        if (isJson) {
            err.println(StatusMsgJsonEntity.getJsonString("STATUS=ERROR", "MSG=CLI: " + (msg != null ? msg.replace('\"', '\'') : "")));
        } else {
            err.println("STATUS=ERROR MSG=\"CLI: " + (msg != null ? msg.replace('\"', '\'') : "") + "\"");
        }
    }

    public final void printError(String obj, String source, ServiceException se, RestError restError) throws ServiceException {
        if (se instanceof ObjectNotFoundException && se.getParameter().length > 0) {
            ObjectNotFoundException onfe = (ObjectNotFoundException)se;
            Object param = (String)onfe.getParameter()[0];
            if (((String)param).endsWith("s") && Character.isUpperCase(((String)param).charAt(0))) {
                param = Character.toLowerCase(((String)param).charAt(0)) + ((String)param).substring(1, ((String)param).length() - 1);
            }
            this.throwError((String)param + " '" + onfe.getParameter()[1] + "' not found in DB");
        } else if (se instanceof ObjectInUseException && se.getParameter().length > 0) {
            ObjectInUseException oiue = (ObjectInUseException)se;
            this.throwError(oiue.getLongMessage());
        } else if (se instanceof IllegalParameterException && se.getLogMessage() == IllegalParameterException.IPEMessage.CONSTRAINT_DUPLICATE) {
            this.throwError(obj + " '" + se.getParameter()[0] + "' already exists");
        } else if (se instanceof OperationNotPossibleException && (se.getLogMessage() == OperationNotPossibleException.ONPMessage.DUPLICATE_ENTRY || se.getLogMessage() == OperationNotPossibleException.ONPMessage.DUPLICATE_ENTRY_CASE_INSENSITIVE)) {
            Object param = (String)se.getParameter()[0];
            if (((String)param).endsWith("s") && Character.isUpperCase(((String)param).charAt(0))) {
                param = Character.toLowerCase(((String)param).charAt(0)) + ((String)param).substring(1, ((String)param).length() - 1);
            }
            if (se.getLogMessage() == OperationNotPossibleException.ONPMessage.DUPLICATE_ENTRY_CASE_INSENSITIVE) {
                this.throwError((String)param + " '" + se.getParameter()[1] + "' already exists (case insensitive)");
            } else {
                this.throwError((String)param + " '" + se.getParameter()[1] + "' already exists");
            }
        } else if (se instanceof ConnectionException && se.getParameter().length > 0) {
            ConnectionException onpe = (ConnectionException)se;
            String param = (String)onpe.getParameter()[0];
            this.throwError(param);
        } else if (restError != null) {
            this.throwError((String)(StringUtils.isNotBlank(source) && !StringUtils.startsWith(restError.getMessage(), source + ": ") ? source + ": " : "") + StringUtils.trim(restError.getMessage().replace('\"', '\'')));
        } else {
            this.throwError((String)(StringUtils.isNotBlank(source) ? source + ": " : "") + "Fatal Error");
        }
    }

    public void throwError(String msg) throws ServiceException {
        this.throwError((LogMessage)null, msg);
    }

    public void throwError(LogMessage key, String msg) throws ServiceException {
        SimpleMessage finKey = new SimpleMessage(key != null ? key.key() : CliCommonErrorException.CCEMessage.GENERAL_ERROR.key(), "{0}");
        if (this.isJsonFormat) {
            throw new CliCommonErrorException(finKey, StatusMsgJsonEntity.getJsonString("STATUS=ERROR", "MSG=CLI: " + (msg != null ? msg.replace('\"', '\'') : "")));
        }
        throw new CliCommonErrorException(finKey, "STATUS=ERROR MSG=\"CLI: " + (msg != null ? msg.replace('\"', '\'') : "") + "\"");
    }

    public void throwError(String source, String msg) throws ServiceException {
        if (this.isJsonFormat) {
            throw new CliCommonErrorException(CliCommonErrorException.CCEMessage.GENERAL_ERROR, StatusMsgJsonEntity.getJsonString("STATUS=ERROR", "MSG=" + source + ": " + (msg != null ? msg.replace('\"', '\'') : "")));
        }
        throw new CliCommonErrorException(CliCommonErrorException.CCEMessage.GENERAL_ERROR, "STATUS=ERROR MSG=\"" + source + ": " + (msg != null ? msg.replace('\"', '\'') : "") + "\"");
    }

    public CliResultEntity printSuccess(String msg) {
        CliResultEntity res = new CliResultEntity();
        if (this.isJsonFormat) {
            res.setResults(StatusMsgJsonEntity.getJsonString("STATUS=SUCCESS", "MSG=" + (StringUtils.isNotBlank(msg) ? msg.trim() : "")));
        } else {
            res.setResults("STATUS=SUCCESS MSG=\"" + (StringUtils.isNotBlank(msg) ? msg.trim() : "") + "\"");
        }
        return res;
    }

    public CliResultEntity printWarning(String msg) {
        CliResultEntity res = new CliResultEntity();
        if (this.isJsonFormat) {
            res.setResults(StatusMsgJsonEntity.getJsonString("STATUS=WARNING", "MSG=" + (StringUtils.isNotBlank(msg) ? msg.trim() : "")));
        } else {
            res.setResults("STATUS=WARNING MSG=\"" + (StringUtils.isNotBlank(msg) ? msg.trim() : "") + "\"");
        }
        return res;
    }

    @Generated
    public void setJsonFormat(boolean isJsonFormat) {
        this.isJsonFormat = isJsonFormat;
    }

    @Generated
    public boolean isJsonFormat() {
        return this.isJsonFormat;
    }
}

