/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.cli.core.utils;

import de.sep.sesam.cli.core.params.BaseParams;
import de.sep.sesam.cli.core.utils.CliParser;
import de.sep.sesam.model.cli.CliCommandType;
import de.sep.sesam.model.cli.CliParamsDtoV2;
import de.sep.sesam.rest.exceptions.IllegalParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CliParamsParserClient {
    public static CliParamsDtoV2 buildParams(BaseParams baseParams, String ... args) throws IllegalParameterException {
        assert (baseParams != null);
        Integer commandPos = null;
        CliCommandType command = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                ++i;
                continue;
            }
            for (CliCommandType c : CliCommandType.values()) {
                if (!args[i].equalsIgnoreCase(c.name())) continue;
                commandPos = i;
                command = c;
                break;
            }
            if (command != null) break;
            throw new IllegalParameterException(IllegalParameterException.IPEMessage.INVALID_VALUE, "command", args[i]);
        }
        if (StringUtils.containsIgnoreCase(StringUtils.join((Object[])args, " "), "-f json")) {
            baseParams.setFormat("json");
        }
        if (commandPos == null) {
            commandPos = args.length;
        }
        List<String> unfiltered = Arrays.asList(args);
        List<String> baseParamsList = unfiltered.subList(0, commandPos);
        List<String> postCommand = unfiltered.subList(commandPos, unfiltered.size());
        CliParser parser = new CliParser(baseParamsList.toArray(new String[0]), baseParams);
        parser.parse();
        String[] basicParam = baseParams.convertToCommandLine();
        CliParamsDtoV2 result = new CliParamsDtoV2();
        ArrayList argsList = Arrays.stream(basicParam).collect(Collectors.toCollection(ArrayList::new));
        argsList.addAll(postCommand);
        result.setArgs(argsList);
        return result;
    }
}

