/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.cli.core.params;

import com.beust.jcommander.Parameter;
import de.sep.sesam.model.cli.BaseParamsDto;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import lombok.Generated;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

public class BaseParams {
    @Parameter(names={"-S", "-s", "--server"}, description="Cli.CliParams.Server")
    private String server = "localhost";
    @Parameter(names={"-p", "--port"}, description="Cli.CliParams.Port")
    private int port = 11401;
    @Parameter(names={"-U", "--user"}, description="Cli.CliParams.User")
    private String user;
    @Parameter(names={"-P", "--password"}, description="Cli.CliParams.Password")
    private String password;
    @Parameter(names={"-z", "--certificate"}, description="Cli.CliParams.Certificate")
    private String certificate;
    @Parameter(names={"-f", "--path"}, description="Cli.CliParams.Path")
    private String path;
    @Parameter(names={"-v"}, description="Cli.CliParams.Verbosity")
    private int verbosity = 0;
    @Parameter(names={"-h", "--help", "help"}, description="Cli.CliParams.Help", help=true)
    private boolean help = false;
    @Parameter(names={"-a", "--show-all"}, description="Cli.CliParams.Hidden")
    private boolean showAllHidden;
    @Parameter(names={"-F"}, description="Cli.CliParams.Format")
    private String format;
    @Parameter(names={"--dry-mode", "-dry-mode"})
    private boolean dryMode = false;
    @Parameter(names={"-t", "--timeout"}, description="Cli.CliParams.Timeout")
    private int connectTimeout = 0;
    @Parameter(names={"-R", "--redirect"}, description="Cli.CliParams.Redirect")
    private List<String> redirectServer;
    @Parameter(names={"-Z"}, description="Cli.CliParams.Authority")
    private String authorityPath;
    @Parameter(names={"-C"}, description="Cli.CliParams.Code")
    private String tfaVerCode;
    @Parameter(names={"-K"}, description="Cli.CliParams.ApiKey")
    private String apiKey;

    public String[] convertToCommandLine() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank(this.server)) {
            sb.append("-s ").append(this.server).append(" ");
        }
        sb.append("-p ").append(this.port).append(" ");
        if (StringUtils.isNotBlank(this.user)) {
            sb.append("-U ").append(this.user).append(" ");
        }
        if (StringUtils.isNotBlank(this.password)) {
            sb.append("-P ").append(this.password).append(" ");
        }
        if (StringUtils.isNotBlank(this.certificate)) {
            sb.append("-z ").append(this.certificate).append(" ");
        }
        if (StringUtils.isNotBlank(this.path)) {
            sb.append("-f ").append(this.path).append(" ");
        }
        sb.append("-v ").append(this.verbosity).append(" ");
        if (this.help) {
            sb.append("-h ").append(this.help).append(" ");
        }
        if (this.showAllHidden) {
            sb.append("-a ").append(this.showAllHidden).append(" ");
        }
        if (StringUtils.isNotBlank(this.format)) {
            sb.append("-F ").append(this.format).append(" ");
        }
        if (this.dryMode) {
            sb.append("-dry-mode ").append(this.dryMode).append(" ");
        }
        sb.append("-t ").append(this.connectTimeout).append(" ");
        if (StringUtils.isNotBlank(this.tfaVerCode)) {
            sb.append("-C ").append(this.tfaVerCode).append(" ");
        }
        if (StringUtils.isNotBlank(this.apiKey)) {
            sb.append("-K ").append(this.apiKey).append(" ");
        }
        return sb.toString().split(" ");
    }

    public BaseParamsDto toDto() {
        BaseParamsDto baseParamsDto = new BaseParamsDto();
        try {
            PropertyUtils.copyProperties(baseParamsDto, this);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return baseParamsDto;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getCertificate() {
        return this.certificate;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public int getVerbosity() {
        return this.verbosity;
    }

    @Generated
    public boolean isHelp() {
        return this.help;
    }

    @Generated
    public boolean isShowAllHidden() {
        return this.showAllHidden;
    }

    @Generated
    public String getFormat() {
        return this.format;
    }

    @Generated
    public boolean isDryMode() {
        return this.dryMode;
    }

    @Generated
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Generated
    public List<String> getRedirectServer() {
        return this.redirectServer;
    }

    @Generated
    public String getAuthorityPath() {
        return this.authorityPath;
    }

    @Generated
    public String getTfaVerCode() {
        return this.tfaVerCode;
    }

    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    @Generated
    public void setHelp(boolean help) {
        this.help = help;
    }

    @Generated
    public void setShowAllHidden(boolean showAllHidden) {
        this.showAllHidden = showAllHidden;
    }

    @Generated
    public void setFormat(String format) {
        this.format = format;
    }

    @Generated
    public void setDryMode(boolean dryMode) {
        this.dryMode = dryMode;
    }

    @Generated
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Generated
    public void setRedirectServer(List<String> redirectServer) {
        this.redirectServer = redirectServer;
    }

    @Generated
    public void setAuthorityPath(String authorityPath) {
        this.authorityPath = authorityPath;
    }

    @Generated
    public void setTfaVerCode(String tfaVerCode) {
        this.tfaVerCode = tfaVerCode;
    }

    @Generated
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }
}

