/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.cli.client.output.show;

import de.sep.sesam.cli.core.params.BaseParams;
import de.sep.sesam.cli.core.utils.CliRequestExecutorClient;
import de.sep.sesam.common.util.HostUtils;
import de.sep.sesam.model.cli.ShowCommandDto;
import de.sep.sesam.model.cli.ShowFileChunk;
import de.sep.sesam.model.dto.ServerFileListDto;
import de.sep.sesam.model.v2.server.ServerFileType;
import de.sep.sesam.rest.DefaultQueryParameter;
import de.sep.sesam.rest.json.JsonResult;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ShowCommandOutputHandler {
    private static final int MAX_CHUNK_SIZE = 524288;
    private final CliRequestExecutorClient executorClient = new CliRequestExecutorClient();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeShow(ShowCommandDto model, PrintStream out, PrintStream err, BaseParams baseParams) throws IOException {
        List<ServerFileListDto> files = model.getFiles();
        ServerFileType type = model.getFilter() != null ? model.getFilter().getType() : null;
        String filterSubType = model.getQueryParams().get("subtype");
        String filterSelector = model.getQueryParams().get("selector");
        if (files != null && files.size() > 1) {
            if (ServerFileType.LOG.equals((Object)type) && StringUtils.equalsAnyIgnoreCase(filterSubType, "backup", "restore", "media", "migration")) {
                if (StringUtils.isBlank(filterSelector)) {
                    this.executeShowSingleFile(model, files.get(0), out, err, baseParams);
                    return 0;
                } else {
                    ServerFileListDto file = null;
                    for (ServerFileListDto candidate : files) {
                        if (!filterSelector.equals(candidate.getSelector())) continue;
                        file = candidate;
                        break;
                    }
                    if (file == null) return 0;
                    this.executeShowSingleFile(model, files.get(0), out, err, baseParams);
                }
                return 0;
            }
            if (model.getQueryParams().get("offset") == null && model.getQueryParams().get("length") == null) {
                this.executeShowAll(model, files, out, err, baseParams);
                return 0;
            }
            long offset = model.getQueryParams().get("offset") != null ? Long.valueOf(model.getQueryParams().get("offset")) : Long.valueOf(0L);
            long length = 0L;
            if (StringUtils.isNotBlank(model.getQueryParams().get("length"))) {
                try {
                    length = Math.abs(Integer.parseInt(model.getQueryParams().get("length")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (offset < 0L && length == 0L) {
                length = 524288L;
            }
            ArrayList<ShowFileChunk> chunks = new ArrayList<ShowFileChunk>();
            if (offset < 0L) {
                long totalBytes = 0L;
                for (ServerFileListDto file : files) {
                    if (file.getSize() == null) continue;
                    long headerSize = this.getShowFileHeader(file).length();
                    long sizeWithHeader = file.getSize() + headerSize;
                    totalBytes += sizeWithHeader;
                }
                totalBytes = offset == -1L ? (totalBytes -= length) : (totalBytes -= Math.abs(offset));
                offset = totalBytes;
            }
            if (offset >= 0L) {
                long bytesSkipped = 0L;
                long totalBytes = 0L;
                for (ServerFileListDto file : files) {
                    if (file.getSize() == null) continue;
                    ShowFileChunk chunk = new ShowFileChunk();
                    long headerSize = this.getShowFileHeader(file).length();
                    long sizeWithHeader = file.getSize() + headerSize;
                    if (offset >= bytesSkipped && offset < bytesSkipped + sizeWithHeader) {
                        chunk.setFile(file);
                        chunk.setOffset(offset - bytesSkipped);
                        assert (chunk.getOffset() >= 0L);
                        chunk.setWithHeader(chunk.getOffset() < headerSize);
                    } else if (offset < bytesSkipped && totalBytes < length) {
                        chunk.setFile(file);
                        chunk.setOffset(0L);
                        chunk.setWithHeader(true);
                    }
                    bytesSkipped += sizeWithHeader;
                    long remainingLength = sizeWithHeader - chunk.getOffset();
                    if (length == 0L) {
                        chunk.setLength(remainingLength);
                    } else {
                        if (totalBytes + remainingLength > length) {
                            remainingLength = length - totalBytes - (chunk.isWithHeader() ? headerSize - chunk.getOffset() : 0L);
                        }
                        chunk.setLength(remainingLength);
                        totalBytes += remainingLength + (chunk.isWithHeader() ? headerSize - chunk.getOffset() : 0L);
                    }
                    chunks.add(chunk);
                    if (length == 0L || totalBytes < length) continue;
                    break;
                }
            }
            this.executeShowChunks(model, chunks, offset, out, err, baseParams);
            return 0;
        }
        if (files != null && files.size() == 1) {
            this.executeShowSingleFile(model, files.get(0), out, err, baseParams);
            return 0;
        } else {
            JsonResult jres = this.showV2(model, out, baseParams);
            if (jres == null || jres.restError == null) return 0;
            throw new IOException(jres.restError.getMessage());
        }
    }

    public void executeShowAll(ShowCommandDto model, List<ServerFileListDto> files, PrintStream out, PrintStream err, BaseParams baseParams) throws IOException {
        if (CollectionUtils.isNotEmpty(files)) {
            JsonResult jres = null;
            String originalName = model.getQueryParams().get("name");
            ServerFileType type = model.getFilter() != null ? model.getFilter().getType() : null;
            for (ServerFileListDto file : files) {
                if (ServerFileType.PATH.equals((Object)type)) {
                    model.getQueryParams().put("name", originalName + "/" + file.getName());
                } else {
                    model.getQueryParams().put("name", file.getName());
                }
                String fileHeader = this.getShowFileHeader(file);
                assert (StringUtils.isNotBlank(fileHeader));
                out.println(fileHeader);
                jres = this.showV2(model, out, baseParams);
                if (jres == null || jres.restError == null) continue;
                throw new IOException(jres.restError.getMessage());
            }
        }
    }

    private String getShowFileHeader(ServerFileListDto file) {
        assert (file != null);
        StringBuilder sb = new StringBuilder();
        String newline = HostUtils.isWindowsHost() ? "\r\n" : "\n";
        int l = file.getName().length();
        while (l % 10 != 0) {
            ++l;
        }
        sb.append(StringUtils.repeat("-", l += 10));
        sb.append(newline);
        sb.append("- ");
        sb.append(file.getName());
        sb.append(StringUtils.repeat(" ", l - file.getName().length() - 3));
        sb.append("-");
        sb.append(newline);
        sb.append(StringUtils.repeat("-", l));
        sb.append(newline);
        sb.append(newline);
        return sb.toString();
    }

    private void executeShowSingleFile(ShowCommandDto model, ServerFileListDto file, PrintStream out, PrintStream err, BaseParams baseParams) throws IOException {
        JsonResult jres;
        assert (model != null);
        assert (model.getCommand() != null);
        assert (file != null);
        if (model.getQueryParams().get("length") == null && file.getSize() != null && file.getSize() > 524288L) {
            model.getQueryParams().put("length", String.valueOf(524288));
        }
        if ((jres = this.showV2(model, out, baseParams)) != null && jres.restError != null) {
            throw new IOException(jres.restError.getMessage());
        }
    }

    public void executeShowChunks(ShowCommandDto model, List<ShowFileChunk> chunks, Long offset, PrintStream out, PrintStream err, BaseParams baseParams) throws IOException {
        assert (model != null);
        String originalName = model.getFilter() != null ? model.getFilter().getName() : null;
        ServerFileType type = model.getFilter() != null ? model.getFilter().getType() : null;
        for (ShowFileChunk chunk : chunks) {
            ServerFileListDto file = chunk.getFile();
            if (ServerFileType.PATH.equals((Object)type)) {
                model.getQueryParams().put("name", originalName + "/" + file.getName());
            } else {
                model.getQueryParams().put("name", file.getName());
            }
            String fileHeader = this.getShowFileHeader(file);
            assert (StringUtils.isNotBlank(fileHeader));
            StringBuilder sb = new StringBuilder();
            if (chunk.isWithHeader()) {
                sb.append(chunk.getOffset() == 0L ? fileHeader : fileHeader.substring(Long.valueOf(chunk.getOffset()).intValue()));
            }
            out.println(sb);
            boolean wholeFile = chunk.getOffset() + chunk.getLength() >= file.getSize();
            model.getQueryParams().put("offset", String.valueOf(wholeFile && chunk.getOffset() == 0L ? null : ((long)fileHeader.length() >= chunk.getOffset() ? null : Long.valueOf(chunk.getOffset()))));
            model.getQueryParams().put("length", String.valueOf(wholeFile ? null : Integer.valueOf(Long.valueOf(chunk.getLength()).intValue())));
            this.executeShowSingleFile(model, file, out, err, baseParams);
        }
    }

    /*
     * Exception decompiling
     */
    public JsonResult showV2(ShowCommandDto model, PrintStream out, BaseParams baseParams) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ DefaultQueryParameter lambda$showV2$0(Map.Entry entry) {
        return new DefaultQueryParameter((String)entry.getKey(), (String)entry.getValue());
    }
}

