/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.cli.client.output.download;

import de.sep.sesam.cli.client.output.download.AbstractCountDownTrigger;
import de.sep.sesam.cli.core.params.BaseParams;
import de.sep.sesam.cli.core.utils.CliRequestExecutorClient;
import de.sep.sesam.common.security.EncryptUtils;
import de.sep.sesam.common.text.I18n;
import de.sep.sesam.model.cli.DownloadCommandDto;
import de.sep.sesam.model.dto.ServerFileListDto;
import de.sep.sesam.rest.FileDownloadState;
import de.sep.sesam.rest.exceptions.OperationNotPossibleException;
import de.sep.sesam.rest.json.JsonHttpRequest;
import de.sep.sesam.rest.json.JsonResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import me.tongfei.progressbar.ConsoleProgressBarConsumer;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;

public class DownloadCommandHandler {
    public int executeDownload(DownloadCommandDto model, BaseParams baseParams) throws IOException {
        String cwd;
        String auth;
        assert (model != null);
        Path localDir = null;
        File localFile = null;
        boolean overwrite = false;
        Map<String, String> queryParams = model.getQueryParams();
        CliRequestExecutorClient executorClient = new CliRequestExecutorClient();
        JsonHttpRequest request = executorClient.prepareRequest(baseParams);
        request.setSessionId(model.getSessionId());
        String session = model.getSession();
        if (StringUtils.isNotBlank(session) && StringUtils.isNotBlank(auth = EncryptUtils.getInstance().decrypt(session))) {
            CharArrayBuffer buffer = new CharArrayBuffer(32);
            buffer.append(auth);
            request.setCertificateAuthHeader(new BufferedHeader(buffer));
        }
        if (queryParams.containsKey("localDirPath")) {
            localDir = Paths.get(queryParams.get("localDirPath"), new String[0]);
        }
        if (queryParams.containsKey("localFilePath")) {
            localFile = new File(queryParams.get("localFilePath"));
        }
        if (localDir == null && localFile == null && StringUtils.isNotBlank(cwd = System.getProperty("user.dir"))) {
            File f = new File(cwd);
            if (f.isDirectory() && f.canWrite()) {
                localDir = Paths.get(cwd, new String[0]);
            } else {
                executorClient.printError(System.out, "Can't write to default directory: \"" + cwd + "\". Access denied.", "json".equalsIgnoreCase(baseParams.getFormat()));
                return 2;
            }
        }
        if (queryParams.containsKey("overwrite")) {
            overwrite = Boolean.TRUE.equals(Boolean.valueOf(queryParams.get("overwrite")));
        }
        queryParams.remove("localDirPath");
        queryParams.remove("localFilePath");
        queryParams.remove("overwrite");
        List<ServerFileListDto> files = model.getFiles();
        JsonResult jres = null;
        if (files != null && files.size() > 1) {
            if (localDir == null && localFile != null) {
                OperationNotPossibleException e = new OperationNotPossibleException(OperationNotPossibleException.ONPMessage.PASS_THROUGH, I18n.get("Cli.CliMainImpl.Executor.InvalidParameterForMultiFileDownload", new Object[0]));
                System.err.println(e.toError().getMessage());
                System.exit(2);
            }
            AbstractCountDownTrigger countDownTrigger = new AbstractCountDownTrigger(files.size()){

                @Override
                public void countedDown() {
                    System.out.println("Download completed.");
                }
            };
            String filterType = model.getFileFilter().getType();
            String filterName = model.getFileFilter().getName();
            for (ServerFileListDto file : files) {
                if ("path".equalsIgnoreCase(filterType)) {
                    queryParams.put("name", filterName + "/" + file.getName());
                } else {
                    queryParams.put("name", file.getName());
                }
                jres = this.executeDownload(model.getServer(), model.getPort(), queryParams, localDir, localFile, overwrite, countDownTrigger, request);
                assert (jres != null);
                if (jres.restError == null) continue;
                break;
            }
        } else {
            jres = this.executeDownload(model.getServer(), model.getPort(), queryParams, localDir, localFile, overwrite, null, request);
        }
        if (jres != null && jres.restError != null) {
            throw new IOException(jres.restError.getMessage());
        }
        return 0;
    }

    private JsonResult executeDownload(String server, Integer port, Map<String, String> queryParams, Path localDir, File localFile, boolean overwrite, final AbstractCountDownTrigger countDownTrigger, JsonHttpRequest request) throws IOException {
        String localName;
        assert (queryParams != null);
        assert (request != null);
        StringBuilder label = new StringBuilder("Downloading ");
        if (StringUtils.isNotEmpty(queryParams.get("type"))) {
            label.append(queryParams.get("type").toLowerCase());
            label.append(" ");
        }
        if (StringUtils.isNotBlank(queryParams.get("subtype"))) {
            label.append(queryParams.get("subtype").toLowerCase());
            label.append(" ");
        }
        if (StringUtils.isNotBlank(localName = queryParams.get("name"))) {
            label.append("(");
            label.append(localName);
            label.append(") ");
        }
        label.append("...");
        System.out.println(label);
        final AtomicReference remoteName = new AtomicReference();
        FileDownloadState state = new FileDownloadState(){
            private ProgressBar pb = null;

            @Override
            public void setRemoteName(String name) {
                remoteName.set(name);
            }

            @Override
            public void setTotal(long total) {
                this.pb = new ProgressBarBuilder().setTaskName("   ").setInitialMax(total).setUpdateIntervalMillis(1000).setConsumer(new ConsoleProgressBarConsumer(System.out, -1)).setStyle(ProgressBarStyle.ASCII).setUnit("KB", 1024L).build();
            }

            @Override
            public void setCur(long cur) {
                if (this.pb != null) {
                    this.pb.stepTo(cur);
                }
            }

            @Override
            public void done() {
                if (this.pb != null) {
                    this.pb.close();
                }
                if (StringUtils.isNotBlank((CharSequence)remoteName.get()) && StringUtils.isNotBlank(localName) && !localName.equals(remoteName.get()) && !localName.endsWith((String)remoteName.get())) {
                    System.out.println("   Saved as: " + (String)remoteName.get());
                }
                if (countDownTrigger != null) {
                    countDownTrigger.countDown();
                } else {
                    System.out.println("Download completed.");
                }
            }
        };
        return request.downloadV2(server, port, queryParams, localDir, localFile, overwrite, state);
    }
}

