/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.cli.client.output;

import de.sep.sesam.cli.client.output.CalendarEventsExportHandler;
import de.sep.sesam.cli.client.output.CertificateGenerateHandler;
import de.sep.sesam.cli.client.output.CredentialsExportHandler;
import de.sep.sesam.cli.client.output.download.DownloadCommandHandler;
import de.sep.sesam.cli.client.output.show.ShowCommandOutputHandler;
import de.sep.sesam.cli.core.params.BaseParams;
import de.sep.sesam.cli.core.utils.CliRequestExecutorClient;
import de.sep.sesam.model.cli.CliCommandType;
import de.sep.sesam.model.cli.CliResultEntity;
import de.sep.sesam.rest.exceptions.CliCommonErrorException;
import de.sep.sesam.rest.exceptions.ServiceException;
import de.sep.sesam.rest.json.JsonResult;
import de.sep.sesam.rest.utils.RestError;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class OutputHandler {
    public static int handle(CliRequestExecutorClient executor, JsonResult result, BaseParams baseParams, PrintStream out, PrintStream err) throws IOException {
        Object handler;
        assert (executor != null);
        assert (result != null);
        if (result.restError != null) {
            return OutputHandler.handleError(executor, result.restError, err);
        }
        CliResultEntity resultEntity = result.read(CliResultEntity.class);
        if (resultEntity.getDownloadCommandDto() != null && resultEntity.getDownloadCommandDto().getCommand() == CliCommandType.DOWNLOAD) {
            DownloadCommandHandler handler2 = new DownloadCommandHandler();
            return handler2.executeDownload(resultEntity.getDownloadCommandDto(), baseParams);
        }
        if (resultEntity.getShowCommandDto() != null) {
            ShowCommandOutputHandler handler3 = new ShowCommandOutputHandler();
            return handler3.executeShow(resultEntity.getShowCommandDto(), out, err, baseParams);
        }
        if (resultEntity.getResults() != null) {
            if (StringUtils.isNotBlank(resultEntity.getOutputFileName())) {
                byte[] bytes = Base64.isBase64(resultEntity.getResults()) ? Base64.decodeBase64(resultEntity.getResults()) : resultEntity.getResults().getBytes(StandardCharsets.UTF_8);
                File f = new File(resultEntity.getOutputFileName());
                if (!f.isAbsolute()) {
                    f = new File(System.getProperty("user.dir"), f.getName());
                }
                if (f.exists() && !f.canWrite() || f.isDirectory()) {
                    throw new IOException("Output file '" + f.getAbsolutePath() + "' is not writable or is a directory.");
                }
                Files.write(f.toPath(), bytes, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            } else {
                out.println(StringUtils.trim(resultEntity.getResults()));
            }
        }
        if (resultEntity.getExportCalendarEventsDto() != null) {
            handler = new CalendarEventsExportHandler();
            ((CalendarEventsExportHandler)handler).handle(resultEntity.getExportCalendarEventsDto());
        }
        if (resultEntity.getCredentialsExportDto() != null) {
            handler = new CredentialsExportHandler();
            ((CredentialsExportHandler)handler).handle(resultEntity.getCredentialsExportDto(), out);
        }
        if (resultEntity.getCertificateResultDto() != null) {
            handler = new CertificateGenerateHandler();
            return ((CertificateGenerateHandler)handler).handle(resultEntity.getCertificateResultDto(), baseParams, out, err);
        }
        return resultEntity.getExitCode() != null ? resultEntity.getExitCode() : 0;
    }

    private static int handleError(CliRequestExecutorClient executor, RestError error, PrintStream err) {
        assert (error != null);
        assert (err != null);
        ServiceException exc = error.toServiceException();
        if (exc != null && !(exc instanceof CliCommonErrorException)) {
            try {
                executor.printError(null, null, exc, error);
            }
            catch (ServiceException e) {
                err.println(e.getMessage());
            }
        } else {
            err.println(StringUtils.trim(error.getMessage()));
        }
        return 2;
    }
}

