/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.cli.client.output;

import de.sep.sesam.model.cli.CredentialsExportDto;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.commons.lang3.StringUtils;

public final class CredentialsExportHandler {
    public void handle(CredentialsExportDto dto, PrintStream out) {
        assert (out != null);
        if (dto == null || StringUtils.isBlank(dto.getPrivateKeyName()) || StringUtils.isBlank(dto.getPublicKeyName())) {
            return;
        }
        this.writeFile(dto.getPrivateKeyName(), dto.getPrivateKey(), out);
        this.writeFile(dto.getPublicKeyName(), dto.getPublicKey(), out);
    }

    private void writeFile(String name, String content, PrintStream out) {
        assert (StringUtils.isNotBlank(name));
        assert (out != null);
        Path p = Paths.get(name, new String[0]);
        if (p != null && !p.isAbsolute() && StringUtils.isNotBlank(System.getProperty("user.dir"))) {
            p = Paths.get(System.getProperty("user.dir"), name);
        }
        if (p != null) {
            File f = p.toFile();
            if (f.exists() && !f.canWrite()) {
                out.append("Failed to write to file '").append(f.getAbsolutePath()).append("', because the file exist and is not writeable.").append("\n");
            }
            try {
                Files.writeString(p, (CharSequence)StringUtils.trim(content), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                out.append("Successfully wrote content to file '").append(f.getAbsolutePath()).append("'.").append("\n");
            }
            catch (IOException e) {
                out.append("Failed to write to file '").append(f.getAbsolutePath()).append("'. Cause: ").append(e.getMessage()).append("\n");
            }
        }
    }
}

