/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.cli.client.output;

import de.sep.sesam.cli.core.params.BaseParams;
import de.sep.sesam.cli.core.utils.CliRequestExecutorClient;
import de.sep.sesam.common.security.EncryptUtils;
import de.sep.sesam.common.text.I18n;
import de.sep.sesam.model.cli.CertificateResultDto;
import de.sep.sesam.model.cli.CliResultEntity;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang3.StringUtils;

public final class CertificateGenerateHandler {
    public int handle(CertificateResultDto dto, BaseParams baseParams, PrintStream out, PrintStream err) throws IOException {
        CliRequestExecutorClient executorClient = new CliRequestExecutorClient();
        if (StringUtils.isNotBlank(dto.getStatus())) {
            CliResultEntity en = executorClient.printSuccess(dto.getStatus());
            out.println(en.getResults());
            return 0;
        }
        char[] secret = ("#" + dto.getUserName() + "#").toCharArray();
        String pubKey = dto.getPubKey();
        if (StringUtils.isNotBlank(pubKey)) {
            pubKey = EncryptUtils.getInstance().decrypt(secret, pubKey);
        }
        if (StringUtils.isBlank(pubKey)) {
            executorClient.printError(err, I18n.get("UserSettingsPanel.Message.EmptyResult", new Object[0]), StringUtils.equalsIgnoreCase(baseParams.getFormat(), "json"));
            return 2;
        }
        Object fileName = dto.getFile();
        if (!StringUtils.endsWithIgnoreCase((CharSequence)fileName, ".crt")) {
            fileName = (String)fileName + ".crt";
        }
        try (FileWriter writer = new FileWriter((String)fileName);){
            writer.append("-----BEGIN CERTIFICATE-----\n");
            writer.append(pubKey);
            writer.append("\n-----END CERTIFICATE-----");
        }
        CliResultEntity en = executorClient.printSuccess(I18n.get("Cli.CliMainImpl.Print.SavedCerts", fileName));
        out.println(en.getResults());
        return 0;
    }
}

