/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.cli.client.output;

import biweekly.Biweekly;
import biweekly.ICalendar;
import biweekly.component.VEvent;
import de.sep.sesam.common.text.I18n;
import de.sep.sesam.model.CalendarEvents;
import de.sep.sesam.model.cli.ExportCalendarEventsDto;
import java.io.File;
import java.io.IOException;

public final class CalendarEventsExportHandler {
    public void handle(ExportCalendarEventsDto dto) {
        ICalendar iCalendar = new ICalendar();
        int i = 0;
        if (dto.getCalendarEvents() != null) {
            for (CalendarEvents calendarEvent : dto.getCalendarEvents()) {
                VEvent vEvent = new VEvent();
                if (calendarEvent.getSummary() == null) {
                    calendarEvent.setSummary("Calendar: " + dto.getCalendarName() + " Event: " + i);
                }
                ++i;
                vEvent.setSummary(calendarEvent.getSummary());
                vEvent.setDateStart(calendarEvent.getDateStart());
                vEvent.setDateEnd(calendarEvent.getDateEnd());
                vEvent.addComment(calendarEvent.getActive().toString());
                vEvent.setDescription(calendarEvent.getUsercomment());
                vEvent.setUid(calendarEvent.getUuid());
                iCalendar.addEvent(vEvent);
            }
            File file = new File(dto.getFileName());
            try {
                Biweekly.write(iCalendar).go(file);
            }
            catch (NullPointerException calendarEvent) {
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(2);
            }
            System.out.println(I18n.get("Cli.CliMainImpl.Print.CalendarExportSavedFile", new Object[0]) + " \"" + file.getAbsolutePath() + "\"");
        } else {
            System.out.println(I18n.get("Cli.CliMainImpl.Print.CalendarExportNoEvents", new Object[0]));
        }
    }
}

