/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.cli.client;

import de.sep.sesam.cli.client.output.OutputHandler;
import de.sep.sesam.cli.core.params.BaseParams;
import de.sep.sesam.cli.core.utils.CliRequestExecutorClient;
import de.sep.sesam.common.security.CertificateUtils;
import de.sep.sesam.model.cli.CliParamsDtoV2;
import de.sep.sesam.rest.json.JsonHttpRequest;
import de.sep.sesam.rest.json.JsonResult;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class Runner {
    public static int runCommand(CliParamsDtoV2 cmd, BaseParams baseParams, PrintStream out, PrintStream err, Map<String, byte[]> preloadedFiles) throws ExecutionException, InterruptedException {
        boolean isSlaveRequest;
        assert (cmd != null);
        boolean isLocalAddress = true;
        boolean bl = isSlaveRequest = baseParams.getRedirectServer() != null;
        if (StringUtils.isNotBlank(baseParams.getServer())) {
            try {
                isLocalAddress = Runner.isLocalAddress(InetAddress.getByName(baseParams.getServer()));
            }
            catch (UnknownHostException e) {
                isLocalAddress = false;
            }
        }
        if (isLocalAddress || isSlaveRequest) {
            File cert;
            if (StringUtils.isNotBlank(baseParams.getCertificate())) {
                File f = new File(baseParams.getCertificate());
                assert (f != null);
                if (!f.canRead()) {
                    baseParams.setCertificate(null);
                }
            }
            if ((isLocalAddress || isSlaveRequest) && StringUtils.isBlank(baseParams.getUser()) && StringUtils.isBlank(baseParams.getPassword()) && StringUtils.isBlank(baseParams.getCertificate()) && (cert = CertificateUtils.getUserAuthenticationCertificateFile()) != null && cert.canRead()) {
                baseParams.setUser("sesam");
                baseParams.setCertificate(cert.getAbsolutePath());
                baseParams.setPassword(null);
            }
        }
        if (StringUtils.isBlank(baseParams.getUser())) {
            baseParams.setUser(System.getProperty("user.name"));
        }
        CliRequestExecutorClient executor = new CliRequestExecutorClient();
        String server = baseParams.getServer();
        int port = baseParams.getPort();
        try {
            JsonHttpRequest request = executor.prepareRequestWithoutRedirect(baseParams);
            executor.checkInfoService(server, port, request, out, err);
            JsonHttpRequest jobRequest = executor.prepareRequestSecure(baseParams);
            JsonResult response = jobRequest.call(server, port, "v2/cli", "process", cmd, preloadedFiles);
            return OutputHandler.handle(executor, response, baseParams, out, err);
        }
        catch (IOException e) {
            executor.printError(err, e.getMessage(), StringUtils.equalsIgnoreCase(baseParams.getFormat(), "json"));
            return 2;
        }
    }

    private static boolean isLocalAddress(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    @Generated
    private Runner() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

