/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.cli.client;

import de.sep.sesam.cli.core.utils.ConsoleHandler;
import java.io.ByteArrayOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class FileRetriever {
    private static final List<CommandParamMap> ALLOWED_COMMANDS = Arrays.asList(CommandParamMap.builder().setCommand("add").setObject("credential").setParameter("-i").setAtSignParameter(true).build(), CommandParamMap.builder().setCommand("add").setObject("credential").setParameter("-l").setAtSignParameter(true).build(), CommandParamMap.builder().setCommand("add").setObject("taskgen").setParameter("-f").build(), CommandParamMap.builder().setCommand("add").setObject("restoretask").setParameter("-f").build(), CommandParamMap.builder().setCommand("distribute").setObject("certificate").setParameter("-f").build(), CommandParamMap.builder().setCommand("distribute").setObject("certificate").setParameter("-k").build(), CommandParamMap.builder().setCommand("import").setObject("calendar").setParameter("-f").build(), CommandParamMap.builder().setCommand("import").setObject("client").setParameter("-f").build(), CommandParamMap.builder().setCommand("import").setObject("credential").setParameter("-f").build(), CommandParamMap.builder().setCommand("import").setObject("interface").setParameter("-f").build(), CommandParamMap.builder().setCommand("import").setObject("task").setParameter("-f").build(), CommandParamMap.builder().setCommand("modify").setObject("credential").setAtSignParameter(true).setParameter("-i").build(), CommandParamMap.builder().setCommand("modify").setObject("credential").setAtSignParameter(true).setParameter("-l").build(), CommandParamMap.builder().setCommand("modify").setObject("restoretask").setParameter("-f").build(), CommandParamMap.builder().setCommand("update").setObject("license").setParameter("-f").build(), CommandParamMap.builder().setCommand("send").setObject("mail").setParameter("-a").build(), CommandParamMap.builder().setCommand("send").setObject("mailer").setParameter("-a").build(), CommandParamMap.builder().setCommand("send").setObject("mail").setParameter("-M").build(), CommandParamMap.builder().setCommand("send").setObject("mailer").setParameter("-M").build(), CommandParamMap.builder().setCommand("upload").setObject("log").setParameter("-f").build(), CommandParamMap.builder().setCommand("upload").setObject("vm").setParameter("-f").build());
    private String[] args;
    private boolean compressFiles;

    public Map<String, byte[]> call() {
        ArrayList<String> filtered = new ArrayList<String>();
        List<String> unfiltered = Arrays.asList(this.args);
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (CommandParamMap c : ALLOWED_COMMANDS) {
            String[] splitted;
            if (!unfiltered.stream().anyMatch(s -> StringUtils.equalsIgnoreCase(s, c.getCommand())) || !unfiltered.stream().anyMatch(s -> StringUtils.equalsIgnoreCase(s, c.getObject())) && !unfiltered.stream().anyMatch(s -> StringUtils.equalsIgnoreCase(s, c.getObject().concat("s"))) || !unfiltered.stream().anyMatch(s -> StringUtils.equals(s, c.getParameter()))) continue;
            String value = unfiltered.contains(c.getParameter()) && unfiltered.indexOf(c.getParameter()) + 1 < unfiltered.size() ? unfiltered.get(unfiltered.indexOf(c.getParameter()) + 1) : "";
            for (String val : splitted = value.split(",")) {
                if (!StringUtils.isNotBlank(value)) continue;
                if (c.isAtSignParameter()) {
                    if (!StringUtils.startsWith(value, "@")) continue;
                    filtered.add(StringUtils.removeStart(val.trim(), "@"));
                    continue;
                }
                filtered.add(val.trim());
            }
        }
        for (String path : filtered) {
            try {
                if (StringUtils.equals(path, "-")) {
                    String data = ConsoleHandler.apply();
                    result.put(path, Base64.encodeBase64(data.getBytes()));
                    continue;
                }
                Path p = Paths.get(path, new String[0]);
                if (p != null && !p.isAbsolute() && StringUtils.isNotBlank(System.getProperty("user.dir"))) {
                    p = Paths.get(System.getProperty("user.dir"), path);
                }
                if (p == null || !p.toFile().canRead()) continue;
                if (!this.compressFiles) {
                    byte[] fileData = Files.readAllBytes(p);
                    result.put(path, Base64.encodeBase64(fileData));
                    continue;
                }
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();
                     GZIPOutputStream gzipOutputStream = new GZIPOutputStream(out);){
                    byte[] allBytes = Files.readAllBytes(p);
                    gzipOutputStream.write(allBytes);
                    gzipOutputStream.close();
                    result.put(path, out.toByteArray());
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    @Generated
    public FileRetriever(String[] args, boolean compressFiles) {
        this.args = args;
        this.compressFiles = compressFiles;
    }

    private static class CommandParamMap {
        private String command;
        private String object;
        private String parameter;
        private boolean atSignParameter;

        @Generated
        CommandParamMap(String command, String object, String parameter, boolean atSignParameter) {
            this.command = command;
            this.object = object;
            this.parameter = parameter;
            this.atSignParameter = atSignParameter;
        }

        @Generated
        public static CommandParamMapBuilder builder() {
            return new CommandParamMapBuilder();
        }

        @Generated
        public String getCommand() {
            return this.command;
        }

        @Generated
        public String getObject() {
            return this.object;
        }

        @Generated
        public String getParameter() {
            return this.parameter;
        }

        @Generated
        public boolean isAtSignParameter() {
            return this.atSignParameter;
        }

        @Generated
        public static class CommandParamMapBuilder {
            @Generated
            private String command;
            @Generated
            private String object;
            @Generated
            private String parameter;
            @Generated
            private boolean atSignParameter;

            @Generated
            CommandParamMapBuilder() {
            }

            @Generated
            public CommandParamMapBuilder setCommand(String command) {
                this.command = command;
                return this;
            }

            @Generated
            public CommandParamMapBuilder setObject(String object) {
                this.object = object;
                return this;
            }

            @Generated
            public CommandParamMapBuilder setParameter(String parameter) {
                this.parameter = parameter;
                return this;
            }

            @Generated
            public CommandParamMapBuilder setAtSignParameter(boolean atSignParameter) {
                this.atSignParameter = atSignParameter;
                return this;
            }

            @Generated
            public CommandParamMap build() {
                return new CommandParamMap(this.command, this.object, this.parameter, this.atSignParameter);
            }

            @Generated
            public String toString() {
                return "FileRetriever.CommandParamMap.CommandParamMapBuilder(command=" + this.command + ", object=" + this.object + ", parameter=" + this.parameter + ", atSignParameter=" + this.atSignParameter + ")";
            }
        }
    }
}

