/*
 * Decompiled with CFR 0.152.
 */
package de.sep.sesam.cli;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import com.beust.jcommander.ParameterException;
import de.sep.sesam.cli.client.FileRetriever;
import de.sep.sesam.cli.client.Runner;
import de.sep.sesam.cli.core.params.BaseParams;
import de.sep.sesam.cli.core.utils.CliIndent;
import de.sep.sesam.cli.core.utils.CliParamsParserClient;
import de.sep.sesam.cli.core.utils.CliRequestExecutorClient;
import de.sep.sesam.cli.core.utils.Translator;
import de.sep.sesam.common.brand.SepVersion;
import de.sep.sesam.common.logging.ContextLogger;
import de.sep.sesam.common.logging.SepLogLevel;
import de.sep.sesam.common.text.I18n;
import de.sep.sesam.common.text.TextUtils;
import de.sep.sesam.common.util.HostUtils;
import de.sep.sesam.model.cli.CliParamsDtoV2;
import de.sep.sesam.rest.exceptions.IllegalParameterException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class CliMainImpl {
    private final CliRequestExecutorClient executor = new CliRequestExecutorClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int retValue;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CliMainImpl.class.getClassLoader());
            CliMainImpl mainApp = new CliMainImpl();
            retValue = mainApp.doMain(TextUtils.replaceVariables(args), System.out, System.out, false);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        System.exit(retValue);
    }

    public int doMain(String[] args, PrintStream out, PrintStream err, boolean unitTestMode) {
        CliParamsDtoV2 cliParams;
        String method = "doMain";
        this.initLogger(unitTestMode);
        ContextLogger logger = new ContextLogger(this.getClass());
        String joined = String.join((CharSequence)" ", args);
        int paramIndx = ArrayUtils.indexOf(args, "-Z");
        boolean compressFiles = false;
        try {
            boolean correctCommand;
            boolean bl = correctCommand = StringUtils.containsAnyIgnoreCase(joined, "send") && StringUtils.containsAnyIgnoreCase(joined, "account", "mailer", "mail", "mailaccount") && StringUtils.containsAny((CharSequence)joined, (CharSequence)"-a");
            if (correctCommand) {
                compressFiles = paramIndx != -1 ? !StringUtils.equalsAnyIgnoreCase(args[paramIndx + 1], "false", "n", "no", "0", "off") : true;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            compressFiles = false;
        }
        Map<String, byte[]> fileResult = new FileRetriever(args, compressFiles).call();
        if (fileResult.isEmpty()) {
            fileResult = null;
        }
        if (ArrayUtils.isEmpty(args)) {
            args = new String[]{"-h"};
        }
        BaseParams baseParams = new BaseParams();
        try {
            cliParams = CliParamsParserClient.buildParams(baseParams, args);
        }
        catch (IllegalParameterException ipe) {
            if (ipe.getLogMessage() == IllegalParameterException.IPEMessage.INVALID_VALUE) {
                if (ipe.getParameter()[0].equals("command")) {
                    this.executor.printError(err, I18n.get("Cli.CliMainImpl.Executor.ActionNotSupported", 0, ipe.getParameter()[1]), StringUtils.equalsIgnoreCase(baseParams.getFormat(), "json"));
                } else {
                    this.executor.printError(err, I18n.get("Cli.CliMainImpl.Executor.InvalidParameterArg", 0, ipe.getParameter()[0]), StringUtils.equalsIgnoreCase(baseParams.getFormat(), "json"));
                }
                return 2;
            }
            this.executor.printError(err, ipe.getLongMessage(), StringUtils.equalsIgnoreCase(baseParams.getFormat(), "json"));
            return 2;
        }
        catch (ParameterException | InvalidParameterException pe) {
            this.executor.printError(err, I18n.get("Cli.CliMainImpl.Executor.InvalidParameter", pe.getMessage()), StringUtils.containsAnyIgnoreCase(String.join((CharSequence)" ", args), "-F json"));
            try {
                cliParams = CliParamsParserClient.buildParams(baseParams, "-h");
            }
            catch (IllegalParameterException e) {
                return 2;
            }
        }
        catch (Exception pe) {
            this.executor.printError(err, pe.getMessage(), StringUtils.containsAnyIgnoreCase(String.join((CharSequence)" ", args), "-F json"));
            try {
                cliParams = CliParamsParserClient.buildParams(baseParams, "");
            }
            catch (IllegalParameterException e) {
                return 2;
            }
        }
        if (SepLogLevel.fromString(String.valueOf(baseParams.getVerbosity())).is(SepLogLevel.EXEC) && !StringUtils.equalsIgnoreCase(baseParams.getFormat(), "json")) {
            logger.info("doMain", "CLI version: " + SepVersion.getFullBuildString(), new Object[0]);
            logger.info("doMain", this.buildArgs(args), new Object[0]);
        }
        if (StringUtils.isNotEmpty(baseParams.getPath())) {
            return this.processFile(baseParams, out, err);
        }
        try {
            return Runner.runCommand(cliParams, baseParams, out, err, fileResult);
        }
        catch (InterruptedException | ExecutionException e) {
            this.executor.printError(err, e.getMessage(), StringUtils.equalsIgnoreCase(baseParams.getFormat(), "json"));
            return 2;
        }
    }

    private String buildArgs(String[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append("Arguments: \"sm_cmd\" ");
        for (String arg : args) {
            sb.append("\"");
            sb.append(arg);
            sb.append("\"");
            sb.append(" ");
        }
        return sb.toString();
    }

    private int processFile(BaseParams baseParams, PrintStream out, PrintStream err) {
        List<String> lines;
        String path = baseParams.getPath();
        try {
            lines = this.executor.readCommandFile(path, err, StringUtils.equalsIgnoreCase(baseParams.getFormat(), "json"));
            if (lines == null) {
                return 1;
            }
        }
        catch (IOException e) {
            this.executor.printError(err, I18n.get("Cli.CliMainImpl.Executor.FatalErrorWhileReading", path), StringUtils.equalsIgnoreCase(baseParams.getFormat(), "json"));
            return 2;
        }
        for (String line : lines) {
            CliParamsDtoV2 filecmd;
            String[] lineArgs;
            boolean ignoreError = false;
            if ((line = line.trim()).startsWith("-")) {
                ignoreError = true;
                line = line.substring(1);
            }
            if ((lineArgs = Translator.translateCommandline(line)) == null) continue;
            out.print(CliIndent.indent(CliIndent.Indent.LEVEL0));
            out.println("sm_cmd " + line);
            String[] baseParamsActual = baseParams.convertToCommandLine();
            String[] actualCommand = ArrayUtils.addAll(baseParamsActual, lineArgs);
            BaseParams baseParamsNew = new BaseParams();
            try {
                filecmd = CliParamsParserClient.buildParams(baseParamsNew, actualCommand);
            }
            catch (IllegalParameterException ipe) {
                if (ipe.getLogMessage() == IllegalParameterException.IPEMessage.INVALID_VALUE) {
                    err.print("STATUS=ERROR MSG=");
                    if (ipe.getParameter()[0].equals("command")) {
                        err.println(I18n.get("Cli.CliMainImpl.Executor.ActionNotSupported", 1, ipe.getParameter()[1]) + "'\"");
                    } else {
                        err.println(I18n.get("Cli.CliMainImpl.Executor.InvalidParameterArg", 1, ipe.getParameter()[0]) + "'\"");
                    }
                    return 1;
                }
                err.println("STATUS=ERROR MSG=\"CLI: " + ipe.getLongMessage() + "\"");
                return 1;
            }
            catch (ParameterException pe) {
                err.println(I18n.get("Cli.CliMainImpl.Executor.InvalidParameterInCommand", line));
                return 1;
            }
            int result = 0;
            try {
                result = Runner.runCommand(filecmd, baseParamsNew, out, err, null);
            }
            catch (InterruptedException | ExecutionException e) {
                this.executor.printError(err, e.getMessage(), StringUtils.equalsIgnoreCase(baseParamsNew.getFormat(), "json"));
            }
            if (ignoreError || result == 0) continue;
            return result;
        }
        return 0;
    }

    private void initLogger(boolean unitTestMode) {
        MarkerFactory.getMarker("cli");
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(context);
            context.reset();
            String logConfig = CliMainImpl.findLogbackConfig(unitTestMode);
            if (StringUtils.isBlank(logConfig)) {
                logConfig = HostUtils.getenv("SEP_SESAM_CLI_LOGCONFIG");
            }
            if (StringUtils.isBlank(logConfig)) {
                logConfig = System.getProperty("SEP_SESAM_CLI_LOGCONFIG");
            }
            if (StringUtils.isBlank(logConfig)) {
                configurator.doConfigure(context.getClass().getResourceAsStream(unitTestMode ? "/logback.xml" : "/logback-cli.xml"));
            } else {
                configurator.doConfigure(logConfig);
            }
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
        catch (JoranException je) {
            je.printStackTrace();
        }
    }

    private static String findLogbackConfig(boolean unitTestMode) {
        String configFileName = unitTestMode ? "logback.xml" : "logback-cli.xml";
        String lookupRoot = null;
        try {
            lookupRoot = CliMainImpl.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isNotBlank(lookupRoot)) {
            Path lookupRootPath = new File(lookupRoot).getParentFile().toPath();
            assert (lookupRootPath != null);
            if (!lookupRootPath.endsWith("target")) {
                File f = new File(lookupRootPath.toString(), configFileName);
                if (f.canRead()) {
                    return f.getAbsolutePath();
                }
                f = new File(lookupRootPath.resolve("config").toString(), configFileName);
                if (f.canRead()) {
                    return f.getAbsolutePath();
                }
            }
        }
        return null;
    }
}

