/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.json;

import biweekly.ICalDataType;
import biweekly.Messages;
import biweekly.io.json.JCalPrettyPrinter;
import biweekly.io.json.JCalValue;
import biweekly.io.json.JsonValue;
import biweekly.parameter.ICalParameters;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JCalRawWriter
implements Closeable,
Flushable {
    private final Writer writer;
    private final boolean wrapInArray;
    private final LinkedList<Info> stack = new LinkedList();
    private JsonGenerator generator;
    private boolean prettyPrint = false;
    private boolean componentEnded = false;
    private boolean closeGenerator = true;
    private PrettyPrinter prettyPrinter;

    public JCalRawWriter(Writer writer, boolean wrapInArray) {
        this.writer = writer;
        this.wrapInArray = wrapInArray;
    }

    public JCalRawWriter(JsonGenerator generator) {
        this.writer = null;
        this.generator = generator;
        this.closeGenerator = false;
        this.wrapInArray = false;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this.prettyPrint = true;
        this.prettyPrinter = prettyPrinter;
    }

    public void writeStartComponent(String componentName) throws IOException {
        if (this.generator == null) {
            this.init();
        }
        this.componentEnded = false;
        if (!this.stack.isEmpty()) {
            Info parent = this.stack.getLast();
            if (!parent.wroteEndPropertiesArray) {
                this.generator.writeEndArray();
                parent.wroteEndPropertiesArray = true;
            }
            if (!parent.wroteStartSubComponentsArray) {
                this.generator.writeStartArray();
                parent.wroteStartSubComponentsArray = true;
            }
        }
        this.generator.writeStartArray();
        this.generator.writeString(componentName);
        this.generator.writeStartArray();
        this.stack.add(new Info());
    }

    public void writeEndComponent() throws IOException {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException(Messages.INSTANCE.getExceptionMessage(2, new Object[0]));
        }
        Info cur = this.stack.removeLast();
        if (!cur.wroteEndPropertiesArray) {
            this.generator.writeEndArray();
        }
        if (!cur.wroteStartSubComponentsArray) {
            this.generator.writeStartArray();
        }
        this.generator.writeEndArray();
        this.generator.writeEndArray();
        this.componentEnded = true;
    }

    public void writeProperty(String propertyName, ICalDataType dataType, JCalValue value) throws IOException {
        this.writeProperty(propertyName, new ICalParameters(), dataType, value);
    }

    public void writeProperty(String propertyName, ICalParameters parameters, ICalDataType dataType, JCalValue value) throws IOException {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException(Messages.INSTANCE.getExceptionMessage(2, new Object[0]));
        }
        if (this.componentEnded) {
            throw new IllegalStateException(Messages.INSTANCE.getExceptionMessage(3, new Object[0]));
        }
        this.generator.setCurrentValue(JCalPrettyPrinter.PROPERTY_VALUE);
        this.generator.writeStartArray();
        this.generator.writeString(propertyName);
        this.generator.writeStartObject();
        for (Map.Entry entry : parameters) {
            String name = ((String)entry.getKey()).toLowerCase();
            List values = entry.getValue();
            if (values.isEmpty()) continue;
            if (values.size() == 1) {
                this.generator.writeStringField(name, (String)values.get(0));
                continue;
            }
            this.generator.writeArrayFieldStart(name);
            for (String paramValue : values) {
                this.generator.writeString(paramValue);
            }
            this.generator.writeEndArray();
        }
        this.generator.writeEndObject();
        this.generator.writeString(dataType == null ? "unknown" : dataType.getName().toLowerCase());
        for (JsonValue jsonValue : value.getValues()) {
            this.writeJsonValue(jsonValue);
        }
        this.generator.writeEndArray();
        this.generator.setCurrentValue(null);
    }

    private void writeJsonValue(JsonValue jsonValue) throws IOException {
        if (jsonValue.isNull()) {
            this.generator.writeNull();
            return;
        }
        Object val = jsonValue.getValue();
        if (val != null) {
            this.writeValue(val);
            return;
        }
        List<JsonValue> array = jsonValue.getArray();
        if (array != null) {
            this.writeArray(array);
            return;
        }
        Map<String, JsonValue> object = jsonValue.getObject();
        if (object != null) {
            this.writeObject(object);
            return;
        }
    }

    private void writeValue(Object val) throws IOException {
        if (val instanceof Byte) {
            this.generator.writeNumber(((Byte)val).byteValue());
        } else if (val instanceof Short) {
            this.generator.writeNumber((Short)val);
        } else if (val instanceof Integer) {
            this.generator.writeNumber((Integer)val);
        } else if (val instanceof Long) {
            this.generator.writeNumber((Long)val);
        } else if (val instanceof Float) {
            this.generator.writeNumber(((Float)val).floatValue());
        } else if (val instanceof Double) {
            this.generator.writeNumber((Double)val);
        } else if (val instanceof Boolean) {
            this.generator.writeBoolean((Boolean)val);
        } else {
            this.generator.writeString(val.toString());
        }
    }

    private void writeArray(List<JsonValue> array) throws IOException {
        this.generator.writeStartArray();
        for (JsonValue element : array) {
            this.writeJsonValue(element);
        }
        this.generator.writeEndArray();
    }

    private void writeObject(Map<String, JsonValue> object) throws IOException {
        this.generator.writeStartObject();
        for (Map.Entry<String, JsonValue> entry : object.entrySet()) {
            this.generator.writeFieldName(entry.getKey());
            this.writeJsonValue(entry.getValue());
        }
        this.generator.writeEndObject();
    }

    @Override
    public void flush() throws IOException {
        if (this.generator == null) {
            return;
        }
        this.generator.flush();
    }

    public void closeJsonStream() throws IOException {
        if (this.generator == null) {
            return;
        }
        while (!this.stack.isEmpty()) {
            this.writeEndComponent();
        }
        if (this.wrapInArray) {
            this.generator.writeEndArray();
        }
        if (this.closeGenerator) {
            this.generator.close();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.generator == null) {
            return;
        }
        this.closeJsonStream();
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private void init() throws IOException {
        JsonFactory factory = new JsonFactory();
        factory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        this.generator = factory.createGenerator(this.writer);
        if (this.prettyPrint) {
            if (this.prettyPrinter == null) {
                this.prettyPrinter = new JCalPrettyPrinter();
            }
            this.generator.setPrettyPrinter(this.prettyPrinter);
        }
        if (this.wrapInArray) {
            this.generator.writeStartArray();
        }
    }

    private static class Info {
        public boolean wroteEndPropertiesArray = false;
        public boolean wroteStartSubComponentsArray = false;

        private Info() {
        }
    }
}

