/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.json;

import biweekly.Biweekly;
import biweekly.ICalendar;
import biweekly.io.TimezoneAssignment;
import biweekly.io.json.JCalDeserializer;
import biweekly.io.json.JCalSerializer;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.property.ICalProperty;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.module.SimpleModule;

public class JCalModule
extends SimpleModule {
    private static final long serialVersionUID = 8022429868572303471L;
    private static final String MODULE_NAME = "biweekly-jcal";
    private static final Version MODULE_VERSION = JCalModule.moduleVersion();
    private final JCalDeserializer deserializer = new JCalDeserializer();
    private final JCalSerializer serializer = new JCalSerializer();
    private ScribeIndex index;

    public JCalModule() {
        super(MODULE_NAME, MODULE_VERSION);
        this.setScribeIndex(new ScribeIndex());
        this.addSerializer(this.serializer);
        this.addDeserializer(ICalendar.class, this.deserializer);
    }

    private static Version moduleVersion() {
        String[] split = Biweekly.VERSION.split("[.-]");
        if (split.length < 3) {
            return new Version(0, 0, 0, "", Biweekly.GROUP_ID, Biweekly.ARTIFACT_ID);
        }
        int major = Integer.parseInt(split[0]);
        int minor = Integer.parseInt(split[1]);
        int patch = Integer.parseInt(split[2]);
        String snapshot = split.length > 3 ? split[3] : "RELEASE";
        return new Version(major, minor, patch, snapshot, Biweekly.GROUP_ID, Biweekly.ARTIFACT_ID);
    }

    public void registerScribe(ICalPropertyScribe<? extends ICalProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
        this.serializer.setScribeIndex(index);
        this.deserializer.setScribeIndex(index);
    }

    public TimezoneAssignment getGlobalTimezone() {
        return this.serializer.getGlobalTimezone();
    }

    public void setGlobalTimezone(TimezoneAssignment globalTimezone) {
        this.serializer.setGlobalTimezone(globalTimezone);
    }
}

