/*
 * Decompiled with CFR 0.152.
 */
package BlowfishJ;

import BlowfishJ.BinConverter;
import BlowfishJ.BlowfishCBC;
import BlowfishJ.SHA1;
import java.util.Random;

public class BlowfishEasy {
    BlowfishCBC m_bfish;
    static Random m_rndGen = new Random();

    public BlowfishEasy(String sPassword) {
        SHA1 hasher = new SHA1();
        hasher.update(sPassword);
        hasher.finalize();
        this.m_bfish = new BlowfishCBC(hasher.getDigest(), 0L);
        hasher.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptString(String sPlainText) {
        long lCBCIV;
        Random random = m_rndGen;
        synchronized (random) {
            lCBCIV = m_rndGen.nextLong();
        }
        return this.encStr(sPlainText, lCBCIV);
    }

    public String encryptString(String sPlainText, Random rndGen) {
        long lCBCIV = rndGen.nextLong();
        return this.encStr(sPlainText, lCBCIV);
    }

    private String encStr(String sPlainText, long lNewCBCIV) {
        int nStrLen = sPlainText.length();
        byte[] buf = new byte[(nStrLen << 1 & 0xFFFFFFF8) + 8];
        int nPos = 0;
        for (int nI = 0; nI < nStrLen; ++nI) {
            char cActChar = sPlainText.charAt(nI);
            buf[nPos++] = (byte)(cActChar >> 8 & 0xFF);
            buf[nPos++] = (byte)(cActChar & 0xFF);
        }
        byte bPadVal = (byte)(buf.length - (nStrLen << 1));
        while (nPos < buf.length) {
            buf[nPos++] = bPadVal;
        }
        this.m_bfish.setCBCIV(lNewCBCIV);
        this.m_bfish.encrypt(buf);
        byte[] newCBCIV = new byte[8];
        BinConverter.longToByteArray(lNewCBCIV, newCBCIV, 0);
        return BinConverter.bytesToBinHex(newCBCIV, 0, 8) + BinConverter.bytesToBinHex(buf, 0, buf.length);
    }

    public String decryptString(String sCipherText) {
        int nLen = sCipherText.length() >> 1 & 0xFFFFFFF8;
        if (nLen < 8) {
            return null;
        }
        byte[] cbciv = new byte[8];
        int nNumOfBytes = BinConverter.binHexToBytes(sCipherText, cbciv, 0, 0, 8);
        if (nNumOfBytes < 8) {
            return null;
        }
        this.m_bfish.setCBCIV(cbciv);
        if ((nLen -= 8) == 0) {
            return "";
        }
        byte[] buf = new byte[nLen];
        nNumOfBytes = BinConverter.binHexToBytes(sCipherText, buf, 16, 0, nLen);
        if (nNumOfBytes < nLen) {
            return null;
        }
        this.m_bfish.decrypt(buf);
        int nPadByte = buf[buf.length - 1] & 0xFF;
        if (nPadByte == 0) {
            nPadByte = buf[buf.length - 2] & 0xFF;
        }
        if (nPadByte > 8 || nPadByte < 0) {
            nPadByte = 0;
        }
        if ((nNumOfBytes -= nPadByte) < 0) {
            return "";
        }
        return BinConverter.byteArrayToUNCString(buf, 0, nNumOfBytes);
    }

    public void destroy() {
        this.m_bfish.cleanUp();
    }
}

